/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.MetadataNodeManager;
import org.jline.reader.Candidate;

public final class CommandUtils {
    public static List<String> getEffectivePaths(List<String> paths) {
        ArrayList<String> effectivePaths = new ArrayList<String>();
        for (String path : paths) {
            if (path.isEmpty()) continue;
            effectivePaths.add(path);
        }
        if (effectivePaths.isEmpty()) {
            effectivePaths.add(".");
        }
        return effectivePaths;
    }

    public static void completeCommand(String commandPrefix, List<Candidate> candidates) {
        String command = Commands.TYPES.ceilingKey(commandPrefix);
        while (command != null && command.startsWith(commandPrefix)) {
            candidates.add(new Candidate(command));
            command = Commands.TYPES.higherKey(command);
        }
    }

    public static List<String> splitPath(String path) {
        ArrayList<String> results = new ArrayList<String>();
        String[] components = path.split("/");
        for (int i = 0; i < components.length; ++i) {
            if (components[i].isEmpty()) continue;
            results.add(components[i]);
        }
        return results;
    }

    public static List<String> stripDotPathComponents(List<String> input) {
        ArrayList<String> output = new ArrayList<String>();
        for (String string : input) {
            if (string.equals("..")) {
                if (output.size() <= 0) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if (string.equals(".")) continue;
            output.add(string);
        }
        return output;
    }

    public static void completePath(MetadataNodeManager nodeManager, String pathPrefix, List<Candidate> candidates) throws Exception {
        nodeManager.visit(data -> {
            String absolutePath = pathPrefix.startsWith("/") ? pathPrefix : data.workingDirectory() + "/" + pathPrefix;
            List<String> pathComponents = CommandUtils.stripDotPathComponents(CommandUtils.splitPath(absolutePath));
            MetadataNode.DirectoryNode directory = data.root();
            int numDirectories = pathPrefix.endsWith("/") ? pathComponents.size() : pathComponents.size() - 1;
            for (int i = 0; i < numDirectories; ++i) {
                MetadataNode node = directory.child(pathComponents.get(i));
                if (node == null || !(node instanceof MetadataNode.DirectoryNode)) {
                    return;
                }
                directory = (MetadataNode.DirectoryNode)node;
            }
            String lastComponent = "";
            if (numDirectories >= 0 && numDirectories < pathComponents.size()) {
                lastComponent = pathComponents.get(numDirectories);
            }
            Map.Entry<String, MetadataNode> candidate = directory.children().ceilingEntry(lastComponent);
            int lastSlash = pathPrefix.lastIndexOf(47);
            String effectivePrefix = lastSlash < 0 ? "" : pathPrefix.substring(0, lastSlash + 1);
            while (candidate != null && candidate.getKey().startsWith(lastComponent)) {
                StringBuilder candidateBuilder = new StringBuilder();
                candidateBuilder.append(effectivePrefix).append(candidate.getKey());
                boolean complete = true;
                if (candidate.getValue() instanceof MetadataNode.DirectoryNode) {
                    candidateBuilder.append("/");
                    complete = false;
                }
                candidates.add(new Candidate(candidateBuilder.toString(), candidateBuilder.toString(), null, null, null, null, complete));
                candidate = directory.children().higherEntry(candidate.getKey());
            }
        });
    }
}

