/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H'J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\f\u001a\u00020\bH&J0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H'J:\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H'J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u0012H'J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H'J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H'J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H'J\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u001d2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0017J&\u0010\u001e\u001a\u00020\u00052\b\b\u0001\u0010\u001f\u001a\u00020\u00032\b\b\u0001\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020#H'\u00a8\u0006$"}, d2={"Lde/justsoftware/wikiservice/persistence/WikiRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/Wiki;", "Lde/justsoftware/wikiservice/model/WikiId;", "deleteAllByDeletionIdIn", "", "deletionIds", "", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleteAllByDeletionIds", "", "findAllByDeletionId", "deletionId", "findAllByPermissionRoles", "Lorg/springframework/data/domain/Page;", "granteeIds", "Lde/justsoftware/wikiservice/model/GranteeId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByPermissionRolesAndSubscriber", "subscriberId", "", "findAllByTenantId", "findAllByTenantIdAndSubscriber", "findByDeletionIdIsNullAndIdIn", "ids", "findByIds", "", "setUpdatedStatus", "wikiId", "updatedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "updatedAt", "Ljava/time/Instant;", "wiki-service"})
public interface WikiRepository
extends DeletionFlagRepository<Wiki, WikiId> {
    @Query(value="SELECT w FROM Wiki w WHERE w.tenantId = :tenantId AND w.deletionId = null")
    @NotNull
    public Page<Wiki> findAllByTenantId(@Param(value="tenantId") @NotNull TenantId var1, @NotNull Pageable var2);

    @Query(value="\n            SELECT w\n            FROM Wiki w\n            WHERE w.tenantId = :tenantId\n            AND w.deletionId = null\n        ")
    @NotNull
    public List<Wiki> findAllByTenantId(@Param(value="tenantId") @NotNull TenantId var1);

    @Query(value="SELECT w FROM Wiki w INNER JOIN Subscription s ON (w.id = s.itemId AND s.itemType = 'WIKI_WIKI') WHERE w.tenantId = :tenantId AND s.isSubscribed = true AND s.subscriber = :subscriber AND w.deletionId = null")
    @NotNull
    public Page<Wiki> findAllByTenantIdAndSubscriber(@Param(value="tenantId") @NotNull TenantId var1, @Param(value="subscriber") long var2, @NotNull Pageable var4);

    @Query(value="SELECT w FROM Wiki w WHERE EXISTS ( SELECT p FROM Permission p WHERE w.id = p.wikiId AND p.granteeId IN :granteeIds ) AND w.tenantId = :tenantId AND w.deletionId = null")
    @NotNull
    public Page<Wiki> findAllByPermissionRoles(@Param(value="granteeIds") @NotNull Set<? extends GranteeId> var1, @Param(value="tenantId") @NotNull TenantId var2, @NotNull Pageable var3);

    @Query(value="SELECT w FROM Wiki w INNER JOIN Subscription s ON (w.id = s.itemId AND s.itemType = 'WIKI_WIKI') WHERE EXISTS ( SELECT p FROM Permission p WHERE w.id = p.wikiId AND p.granteeId IN :granteeIds ) AND w.tenantId = :tenantId AND s.isSubscribed = true AND s.subscriber = :subscriber AND w.deletionId = null")
    @NotNull
    public Page<Wiki> findAllByPermissionRolesAndSubscriber(@Param(value="granteeIds") @NotNull Set<? extends GranteeId> var1, @Param(value="tenantId") @NotNull TenantId var2, @Param(value="subscriber") long var3, @NotNull Pageable var5);

    @Deprecated(message="Use {@link #findByIds(Set)} instead.")
    @NotNull
    public List<Wiki> findByDeletionIdIsNullAndIdIn(@NotNull List<? extends WikiId> var1);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<WikiId, Wiki> findByIds(@NotNull Set<? extends WikiId> ids) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)ids, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findByDeletionIdIsNullAndIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (Wiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WikiId wikiId = it.getId();
            if (wikiId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(TuplesKt.to((Object)wikiId, (Object)it));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Set<Wiki> findAllByDeletionId(@NotNull DeletionId var1);

    @Transactional
    @JvmDefault
    default public void deleteAllByDeletionIds(@NotNull Set<? extends DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<? extends DeletionId> var1);

    @Transactional
    @JvmDefault
    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE Wiki w\n            SET w.updatedAt = :updatedAt,\n                w.modifiedBy = :updatedBy\n            WHERE w.id = :wikiId\n        ")
    public void setUpdatedStatus(@Param(value="wikiId") @NotNull WikiId var1, @Param(value="updatedBy") @NotNull ProfileId var2, @Param(value="updatedAt") @NotNull Instant var3);
}

