/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.wikiservice.kafka.DriveItemIdProducer;
import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\b\u0007\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/kafka/DriveItemIdProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;)V", "handleArticleDeletedEvent", "", "evt", "Lde/justsoftware/wikiservice/model/ArticleDeletedEvent;", "send", "itemId", "Lde/justsoftware/wikiservice/model/ArticleId;", "Companion", "wiki-service"})
public class DriveItemIdProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    public static final String TOPIC = "just.items";

    @Autowired
    public DriveItemIdProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        this.kafkaProducer = kafkaProducer;
    }

    @Async
    @EventListener
    public void handleArticleDeletedEvent(@NotNull ArticleDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getId());
    }

    private void send(ArticleId itemId) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)itemId.toString(), null));
    }
}

