/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.hibernate;

import de.justsoftware.wikiservice.hibernate.Oracle10gDialectFix;
import de.justsoftware.wikiservice.hibernate.Oracle12cDialectFix;
import de.justsoftware.wikiservice.hibernate.Oracle8iDialectFix;
import de.justsoftware.wikiservice.hibernate.Oracle9iDialectFix;
import de.justsoftware.wikiservice.hibernate.OracleFixDialectResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lde/justsoftware/wikiservice/hibernate/OracleFixDialectResolver;", "Lorg/hibernate/engine/jdbc/dialect/spi/DialectResolver;", "()V", "resolveDialect", "Lorg/hibernate/dialect/Dialect;", "info", "Lorg/hibernate/engine/jdbc/dialect/spi/DialectResolutionInfo;", "Companion", "wiki-service"})
public final class OracleFixDialectResolver
implements DialectResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long serialVersionUID = 1L;

    @NotNull
    public Dialect resolveDialect(@NotNull DialectResolutionInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (Intrinsics.areEqual((Object)"Oracle", (Object)info.getDatabaseName())) {
            Dialect dialect;
            switch (info.getDatabaseMajorVersion()) {
                case 11: {
                    dialect = (Dialect)new Oracle10gDialectFix();
                    break;
                }
                case 9: {
                    dialect = (Dialect)new Oracle9iDialectFix();
                    break;
                }
                case 8: {
                    dialect = (Dialect)new Oracle8iDialectFix();
                    break;
                }
                default: {
                    dialect = (Dialect)new Oracle12cDialectFix();
                }
            }
            return dialect;
        }
        Dialect dialect = new StandardDialectResolver().resolveDialect(info);
        Intrinsics.checkNotNullExpressionValue((Object)dialect, (String)"StandardDialectResolver().resolveDialect(info)");
        return dialect;
    }
}

