/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.drive;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.wikiservice.drive.exceptions.PersistFilesError;
import de.justsoftware.wikiservice.drive.model.InternalFileModel;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.serializer.ProfileIdSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0012J2\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/wikiservice/drive/DriveAPI;", "", "driveInternalUrl", "", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserializeTmpMove", "", "Lde/justsoftware/wikiservice/drive/model/InternalFileModel;", "input", "persistFiles", "tempIds", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "wiki-service"})
public class DriveAPI {
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestTemplate rest;
    @NotNull
    private final ObjectMapper mapper;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public DriveAPI(@Value(value="${drive.internal:localhost:8080/drive/internal}") @NotNull String driveInternalUrl, @NotNull RestTemplate rest) {
        void $this$mapper_u24lambda_u240;
        ObjectMapper objectMapper;
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.driveInternalUrl = driveInternalUrl;
        this.rest = rest;
        ObjectMapper objectMapper2 = objectMapper = new ObjectMapper();
        DriveAPI driveAPI = this;
        boolean bl = false;
        $this$mapper_u24lambda_u240.registerModule((Module)new JodaModule());
        $this$mapper_u24lambda_u240.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        $this$mapper_u24lambda_u240.registerModule((Module)new ProfileIdSerializer());
        $this$mapper_u24lambda_u240.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        driveAPI.mapper = objectMapper;
    }

    public /* synthetic */ DriveAPI(String string, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, restTemplate);
    }

    @NotNull
    public Map<String, InternalFileModel> persistFiles(@NotNull Set<String> tempIds, @NotNull ArticleId articleId, @NotNull ProfileId creator) {
        Intrinsics.checkNotNullParameter(tempIds, (String)"tempIds");
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)articleId.toString()), TuplesKt.to((Object)"tempFileIds", tempIds), TuplesKt.to((Object)"ownerId", (Object)creator.getId())};
        ResponseEntity it = this.rest.postForEntity(this.driveInternalUrl + "/tmp/move", (Object)MapsKt.mapOf((Pair[])pairArray), String.class, new Object[0]);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            HttpStatus httpStatus = it.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatus, (String)"it.statusCode");
            throw new PersistFilesError(tempIds, httpStatus);
        }
        return this.deserializeTmpMove((String)it.getBody());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, InternalFileModel> deserializeTmpMove(String input) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object it;
        Map map;
        Map $this$mapKeysTo$iv$iv;
        Object object2 = this.mapper.readValue(input, Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mapper\n        .readValue(input, Map::class.java)");
        Map $this$mapKeys$iv = (Map)object2;
        boolean $i$f$mapKeys = false;
        Map map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = String.valueOf(it.getKey());
            Map map3 = map;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl3 = false;
            InternalFileModel internalFileModel = (InternalFileModel)this.mapper.convertValue(it2.getValue(), InternalFileModel.class);
            map.put(k, internalFileModel);
        }
        return destination$iv$iv;
    }
}

