/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.toolbox.performance.PerformanceLogger;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@Aspect
@ConditionalOnProperty(value={"performance.logging.enabled"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/wikiservice/config/PerformanceLoggerConfiguration;", "", "infoThresholdMs", "", "warnThresholdMs", "(JJ)V", "invokePerformanceLogger", "kotlin.jvm.PlatformType", "joinPoint", "Lorg/aspectj/lang/ProceedingJoinPoint;", "wiki-service"})
public class PerformanceLoggerConfiguration {
    private final long infoThresholdMs;
    private final long warnThresholdMs;

    public PerformanceLoggerConfiguration(@Value(value="${performance.logging.infoThresholdMs:50}") long infoThresholdMs, @Value(value="${performance.logging.warnThresholdMs:100}") long warnThresholdMs) {
        this.infoThresholdMs = infoThresholdMs;
        this.warnThresholdMs = warnThresholdMs;
        PerformanceLogger.setPerformanceLoggerEnabled((boolean)true);
        PerformanceLogger.setThresholdTotalNanos((long)TimeUnit.MILLISECONDS.toNanos(this.infoThresholdMs));
        PerformanceLogger.setThresholdWarnNanos((long)TimeUnit.MILLISECONDS.toNanos(this.warnThresholdMs));
    }

    @Around(value="(!within(is(FinalType)) && within(de.justsoftware..*)) || within(org.springframework.data.jpa.repository.JpaRepository+))")
    public Object invokePerformanceLogger(@NotNull ProceedingJoinPoint joinPoint) throws Throwable {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        return PerformanceLogger.logJoinPoint((ProceedingJoinPoint)joinPoint);
    }
}

