/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.persistence.SubscriptionRepository;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/business/SubscriptionService;", "", "subscriptionRepository", "Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;", "(Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;)V", "getIsSubscribedForItems", "", "Lde/justsoftware/wikiservice/model/ItemId;", "", "itemIds", "", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "setSubscription", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "itemId", "isSubscribed", "wiki-service"})
public class SubscriptionService {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public SubscriptionService(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, @NotNull ProfileId subscriber, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Subscription subscription = new Subscription(subscriber, itemId, isSubscribed);
        Object object = this.subscriptionRepository.save((Object)subscription);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"subscriptionRepository.save(subscription)");
        return SubscriptionDto.Companion.toDto((Subscription)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> getIsSubscribedForItems(@NotNull Set<? extends ItemId> itemIds, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        List subscriptions = this.subscriptionRepository.findBySubscriberAndItems(subscriber, itemIds);
        Iterable $this$associateWith$iv = itemIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object v0;
            Map map;
            Object t;
            block2: {
                ItemId itemId = (ItemId)element$iv$iv;
                t = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                Iterable iterable = subscriptions;
                for (Object t2 : iterable) {
                    void itemId2;
                    Subscription it = (Subscription)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)Subscription.Companion.getGetItemId(it), (Object)itemId2)) continue;
                    v0 = t2;
                    break block2;
                }
                v0 = null;
            }
            Subscription subscription = v0;
            Boolean bl = subscription != null ? subscription.isSubscribed() : false;
            map.put(t, bl);
        }
        return result$iv;
    }
}

