/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import com.google.common.base.Charsets;
import de.justsoftware.wikiservice.business.ConfigService;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0012\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0006H\u0012J\u000f\u0010\r\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/wikiservice/business/ConfigService;", "", "zookeeperClient", "Lorg/apache/curator/framework/CuratorFramework;", "(Lorg/apache/curator/framework/CuratorFramework;)V", "wikiCleanupAfterCache", "Lorg/apache/curator/framework/recipes/cache/NodeCache;", "getLong", "", "cache", "(Lorg/apache/curator/framework/recipes/cache/NodeCache;)Ljava/lang/Long;", "getString", "", "wikiCleanupAfterDays", "()Ljava/lang/Long;", "Companion", "wiki-service"})
public class ConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeCache wikiCleanupAfterCache;
    @NotNull
    private static final String WIKI_CLEANUP_AFTER_EXPRESSION_PATH = "/just/wiki/cleanupAfter";

    /*
     * WARNING - void declaration
     */
    public ConfigService(@NotNull CuratorFramework zookeeperClient) {
        void $this$wikiCleanupAfterCache_u24lambda_u240;
        NodeCache nodeCache;
        Intrinsics.checkNotNullParameter((Object)zookeeperClient, (String)"zookeeperClient");
        NodeCache nodeCache2 = nodeCache = new NodeCache(zookeeperClient, WIKI_CLEANUP_AFTER_EXPRESSION_PATH);
        ConfigService configService = this;
        boolean bl = false;
        $this$wikiCleanupAfterCache_u24lambda_u240.start();
        configService.wikiCleanupAfterCache = nodeCache;
    }

    @Nullable
    public Long wikiCleanupAfterDays() {
        Long maxAgeInDays = this.getLong(this.wikiCleanupAfterCache);
        return maxAgeInDays != null && maxAgeInDays >= 0L ? maxAgeInDays : (Long)null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Long getLong(NodeCache cache) {
        ChildData childData = cache.getCurrentData();
        Object object = childData;
        if (childData == null) return null;
        byte[] byArray = object.getData();
        object = byArray;
        if (byArray == null) return null;
        Object object2 = object;
        boolean bl = false;
        String string = this.getString(cache);
        if (string == null) return null;
        Long l = Long.parseLong(string, CharsKt.checkRadix((int)10));
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getString(NodeCache cache) {
        ChildData childData = cache.getCurrentData();
        Object object = childData;
        if (childData == null) return null;
        byte[] byArray = object.getData();
        object = byArray;
        if (byArray == null) return null;
        Object object2 = object;
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string = new String((byte[])object2, charset2);
        return string;
    }
}

