/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.CircularyAncestryException;
import de.justsoftware.wikiservice.business.exceptions.ParentNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.business.model.Ancestor;
import de.justsoftware.wikiservice.business.model.AncestorDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.ChapterNestingException;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0012J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001d\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010(\u001a\u00020\u001dH\u0016J(\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0&2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010+\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0017H\u0012J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\"\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0012J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J\"\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J \u0010=\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J&\u0010=\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J8\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\b\u0002\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00150BH\u0012J\u000e\u0010C\u001a\u0004\u0018\u00010\u001d*\u000202H\u0012J*\u0010D\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0&0E*\b\u0012\u0004\u0012\u00020\u001d0&H\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lde/justsoftware/wikiservice/business/AncestorService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "maxChapterDepth", "", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/WikiRepository;ILde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "checkCircularAncestry", "", "parentAncestors", "", "Lde/justsoftware/wikiservice/business/model/AncestorDto;", "movedElement", "Lde/justsoftware/wikiservice/model/AbstractId;", "checkMaxNestingDepth", "parentChaptersNestingDepth", "childrenChaptersNestingDepth", "checkMaxNestingDepthOfNewChapter", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "checkValidMove", "toParent", "checkValidMove$wiki_service", "getAncestorWikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "getAncestorWikiIds", "", "parentIds", "", "getAncestors", "firstAncestor", "getDescendantChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "wikiId", "getDescendants", "getMaxChildrenChaptersNestingDepth", "childrenId", "getNextPositionForParent", "getPreviousPositionForParent", "loadAncestors", "Lde/justsoftware/wikiservice/business/model/Ancestor;", "firstAncestors", "moveArticle", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "updater", "Lde/justsoftware/wikiservice/model/ProfileId;", "moveChapter", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "updateEditedStatusForAncestors", "updatedAt", "Ljava/time/Instant;", "updatedBy", "ancestors", "", "getParentId", "groupByType", "Lkotlin/Pair;", "wiki-service"})
public class AncestorService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final WikiRepository wikiRepository;
    private final int maxChapterDepth;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public AncestorService(@NotNull PermissionService permissionService, @NotNull ChapterRepository chapterRepository, @NotNull ArticleRepository articleRepository, @NotNull WikiRepository wikiRepository, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.permissionService = permissionService;
        this.chapterRepository = chapterRepository;
        this.articleRepository = articleRepository;
        this.wikiRepository = wikiRepository;
        this.maxChapterDepth = maxChapterDepth;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public WikiId getAncestorWikiId(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = (WikiId)this.getAncestorWikiIds(SetsKt.setOf((Object)parentId)).get(parentId);
        if (wikiId == null) {
            throw new WikiNotFoundException((WikiId)parentId);
        }
        return wikiId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, WikiId> getAncestorWikiIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Collection collection;
        Iterator $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Pair pair = this.groupByType(parentIds);
        Set chapterIds = (Set)pair.component1();
        Set wikiIds = (Set)pair.component2();
        Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            ChapterId id;
            void it;
            Object item$iv$iv = iterator.next();
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (it.getId() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(TuplesKt.to((Object)id, (Object)it.getWikiId()));
        }
        Map chapterAncestor = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = chapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv2;
            boolean bl = false;
            boolean bl2 = chapterAncestor.containsKey(it);
            if (!_Assertions.ENABLED || bl2) continue;
            boolean bl3 = false;
            throw new ChapterNotFoundException(it);
        }
        Iterable $this$map$iv2 = wikiIds;
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void wikiId;
            WikiId bl = (WikiId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)wikiId, (String)"null cannot be cast to non-null type de.justsoftware.wikiservice.model.ParentId");
            collection.add(TuplesKt.to((Object)((ParentId)wikiId), (Object)wikiId));
        }
        Map wikiAncestor = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        return MapsKt.plus((Map)wikiAncestor, (Map)chapterAncestor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<AbstractId> getDescendants(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$map$iv = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set chapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.articleRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article bl = (Article)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        Set articles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set set = SetsKt.plus((Set)chapters, (Iterable)articles);
        Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type kotlin.collections.Set<de.justsoftware.wikiservice.model.AbstractId>");
        return set;
    }

    @NotNull
    public List<AncestorDto> getAncestors(@NotNull ParentId firstAncestor) {
        Intrinsics.checkNotNullParameter((Object)firstAncestor, (String)"firstAncestor");
        return this.getAncestors(SetsKt.setOf((Object)firstAncestor)).getOrDefault(firstAncestor, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<AncestorDto>> getAncestors(@NotNull Set<? extends ParentId> firstAncestor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(firstAncestor, (String)"firstAncestor");
        Map loadedAncestors = this.loadAncestors(firstAncestor);
        Iterable $this$map$iv = firstAncestor;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)AncestorService.getAncestors$default((AncestorService)this, (Map)loadedAncestors, (ParentId)it, null, (int)2, null)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private List<AncestorDto> getAncestors(Map<ParentId, ? extends Ancestor> $this$getAncestors, ParentId parentId, List<AncestorDto> ancestors) {
        ParentId ancestorId = parentId;
        while (ancestorId != null) {
            Ancestor ancestor;
            if ($this$getAncestors.get(ancestorId) == null) {
                throw new ParentNotFoundException(ancestorId);
            }
            ancestors.add(0, new AncestorDto(ancestor.getId(), ancestor.getTitle()));
            ancestorId = this.getParentId(ancestor);
        }
        return ancestors;
    }

    static /* synthetic */ List getAncestors$default(AncestorService ancestorService, Map map, ParentId parentId, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAncestors");
        }
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        return ancestorService.getAncestors(map, parentId, list);
    }

    private ParentId getParentId(Ancestor $this$getParentId) {
        return $this$getParentId instanceof ChapterDto ? ((ChapterDto)$this$getParentId).getParentId() : null;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ParentId, Ancestor> loadAncestors(Set<? extends ParentId> firstAncestors) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map map;
        Set wikiIds;
        Object object2;
        if (firstAncestors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map loadedAncestors = new LinkedHashMap();
        Set parentWikiIds = new LinkedHashSet();
        Set nextParentIds = firstAncestors;
        while (!((Collection)nextParentIds).isEmpty()) {
            Set set;
            object2 = this.groupByType(nextParentIds);
            Set chapterIds = (Set)object2.component1();
            wikiIds = (Set)object2.component2();
            parentWikiIds.addAll(wikiIds);
            if (chapterIds.isEmpty()) {
                set = SetsKt.emptySet();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object it;
                void $this$mapTo$iv$iv;
                Object $this$map$iv;
                Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ChapterId id;
                    map = (Chapter)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    if (it.getId() == null) {
                        throw new ChapterNotFoundException(null, 1, null);
                    }
                    object.add(TuplesKt.to((Object)id, (Object)ChapterDto.Companion.toChapterDto((Chapter)it)));
                }
                $this$map$iv = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                Map it2 = $this$map$iv;
                boolean $i$a$-also-AncestorService$loadAncestors$32 = false;
                loadedAncestors.putAll(it2);
                $i$f$map = false;
                Map $i$a$-also-AncestorService$loadAncestors$32 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    it = item$iv$iv = (Map.Entry)iterator.next();
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(((ChapterDto)it.getValue()).getParentId());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ParentId)element$iv$iv;
                    boolean bl = false;
                    if (!(!loadedAncestors.containsKey(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            nextParentIds = set;
        }
        object2 = this.wikiRepository.findByIds(parentWikiIds);
        object = loadedAncestors;
        boolean $i$f$mapValues = false;
        wikiIds = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object element$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            Wiki wiki = (Wiki)entry.getValue();
            WikiDto wikiDto = WikiDto.Companion.toDto(wiki);
            map2.put(k, wikiDto);
        }
        object.putAll(destination$iv$iv);
        return loadedAncestors;
    }

    private Pair<Set<ChapterId>, Set<WikiId>> groupByType(Set<? extends ParentId> $this$groupByType) {
        Set chapterIds = new LinkedHashSet();
        Set wikiIds = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$groupByType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParentId it = (ParentId)element$iv;
            boolean bl = false;
            ParentId parentId = it;
            if (parentId instanceof WikiId) {
                wikiIds.add(it);
                continue;
            }
            if (parentId instanceof ChapterId) {
                chapterIds.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported parent type: " + it.type());
        }
        return new Pair((Object)chapterIds, (Object)wikiIds);
    }

    @Transactional
    public void updateEditedStatusForAncestors(@NotNull ParentId parentId, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        this.updateEditedStatusForAncestors(SetsKt.setOf((Object)parentId), updatedAt, updatedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateEditedStatusForAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Iterable iterable = CollectionsKt.flatten((Iterable)this.getAncestors(parentIds).values());
        AncestorService ancestorService = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AncestorDto ancestorDto = (AncestorDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Pair pair = ancestorService.groupByType(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Set parentChaptersIds = (Set)pair.component1();
        Set parentWikiIds = (Set)pair.component2();
        WikiId parentWikiId = (WikiId)CollectionsKt.first((Iterable)parentWikiIds);
        this.chapterRepository.setUpdatedStatus(parentChaptersIds, updatedBy, updatedAt);
        this.wikiRepository.setUpdatedStatus(parentWikiId, updatedBy, updatedAt);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean moveChapter(@NotNull ChapterId chapterId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        List updatedChapters;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chapter chapter = (Chapter)this.chapterRepository.getOne((Object)chapterId);
        Intrinsics.checkNotNullExpressionValue((Object)chapter, (String)"chapter");
        ParentId oldParentId = Chapter.Companion.getParent(chapter);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)chapter.getParentId()) && toParent.type() == chapter.getParentType()) {
            return false;
        }
        ChapterId chapterId2 = chapter.getId();
        if (chapterId2 == null) {
            throw new ChapterNotFoundException(chapterId);
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)chapterId2);
        WikiId toWikiId = this.getAncestorWikiId(toParent);
        Set chaptersToUpdate = new LinkedHashSet();
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)chapter.getWikiId())) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            String $this$moveChapter_u24lambda_u2415_u24lambda_u2414;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = this.getDescendantChapters(chapter.getWikiId(), (ParentId)chapterId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void childChapter;
                Chapter chapter2 = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void var18_29 = childChapter;
                $this$moveChapter_u24lambda_u2415_u24lambda_u2414 = var18_29;
                boolean bl2 = false;
                $this$moveChapter_u24lambda_u2415_u24lambda_u2414.setWikiId(toWikiId);
                collection.add(var18_29);
            }
            updatedChapters = (List)destination$iv$iv;
            chaptersToUpdate.addAll(updatedChapters);
            Iterable $this$map$iv2 = updatedChapters;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Chapter bl = (Chapter)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                ChapterId chapterId3 = it.getId();
                if (chapterId3 == null) {
                    $this$moveChapter_u24lambda_u2415_u24lambda_u2414 = "Required value was null.";
                    throw new IllegalStateException($this$moveChapter_u24lambda_u2415_u24lambda_u2414.toString());
                }
                collection.add(chapterId3);
            }
            Set parentIds = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), (Iterable)SetsKt.setOf((Object)chapterId));
            Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)this.articleRepository.findByParentIds(parentIds).values());
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void article;
                void var20_35;
                Article bl3 = (Article)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2418_u24lambda_u2417 = var20_35 = article;
                boolean bl4 = false;
                $this$moveChapter_u24lambda_u2418_u24lambda_u2417.setWikiId(toWikiId);
                collection.add(var20_35);
            }
            List updatedArticles = (List)destination$iv$iv3;
            if (!((Collection)updatedArticles).isEmpty()) {
                this.articleRepository.saveAll((Iterable)updatedArticles);
                Iterable $this$forEach$iv = updatedArticles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Article it = (Article)element$iv;
                    boolean bl = false;
                    ArticleId articleId = it.getId();
                    if (articleId == null) {
                        throw new ArticleNotFoundException(null, 1, null);
                    }
                    this.permissionService.removePermissionsForDeletedArticle(articleId);
                    ArticleId articleId2 = it.getId();
                    if (articleId2 == null) {
                        throw new ArticleNotFoundException(null, 1, null);
                    }
                    this.permissionService.addPermissionItemForNewArticle(articleId2, toWikiId);
                }
                this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
            chapter.setWikiId(toWikiId);
            chapter.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
        } else {
            chapter.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        chapter.setParentId(toParent.getId());
        chapter.setParentType(toParent.type());
        chaptersToUpdate.add(chapter);
        updatedChapters = this.chapterRepository.saveAll((Iterable)chaptersToUpdate);
        Intrinsics.checkNotNullExpressionValue((Object)updatedChapters, (String)"updatedChapters");
        Instant instant = ((Chapter)CollectionsKt.last((List)updatedChapters)).getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    @Transactional
    public boolean moveArticle(@NotNull ArticleId articleId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getOne((Object)articleId);
        Intrinsics.checkNotNullExpressionValue((Object)article, (String)"article");
        ParentId oldParentId = Article.Companion.getParent(article);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)article.getParentId()) && toParent.type() == article.getParentType()) {
            return false;
        }
        ArticleId articleId2 = article.getId();
        if (articleId2 == null) {
            throw new ArticleNotFoundException(articleId);
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)articleId2);
        WikiId $this$moveArticle_u24lambda_u2420 = this.getAncestorWikiId(toParent);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$moveArticle_u24lambda_u2420, (Object)article.getWikiId())) {
            article.setWikiId($this$moveArticle_u24lambda_u2420);
            article.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
            this.permissionService.removePermissionsForDeletedArticle(articleId);
            this.permissionService.addPermissionItemForNewArticle(articleId, (WikiId)toParent);
        } else {
            article.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        article.setParentId(toParent.getId());
        article.setParentType(toParent.type());
        Article updatedArticle = (Article)this.articleRepository.save((Object)article);
        Instant instant = updatedArticle.getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void checkValidMove$wiki_service(@NotNull ParentId toParent, @NotNull AbstractId movedElement) {
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)movedElement, (String)"movedElement");
        ParentId parentId = toParent;
        if (parentId instanceof ChapterId) {
            if (!this.chapterRepository.existsById((Object)toParent)) {
                throw new ChapterNotFoundException((ChapterId)toParent);
            }
            if (movedElement.type() == IdType.WIKI_CHAPTER) {
                List parentAncestors = this.getAncestors(toParent);
                int parentChaptersNestingDepth = parentAncestors.size() - 1;
                int childrenChaptersNestingDepth = this.getMaxChildrenChaptersNestingDepth(movedElement);
                this.checkMaxNestingDepth(parentChaptersNestingDepth, childrenChaptersNestingDepth);
                this.checkCircularAncestry(parentAncestors, movedElement);
            }
        } else if (parentId instanceof WikiId) {
            if (!this.wikiRepository.existsById((Object)toParent)) {
                throw new WikiNotFoundException((WikiId)toParent);
            }
        } else {
            throw new IllegalArgumentException(toParent.type() + " is not a known parent type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChildrenChaptersNestingDepth(AbstractId childrenId) {
        int n;
        if (childrenId instanceof ParentId) {
            void var2_2;
            int depth = 0;
            Set nextParentIds = SetsKt.setOf((Object)childrenId);
            while (!((Collection)nextParentIds).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map children = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, (Set)nextParentIds, null, (int)2, null);
                Iterable iterable = CollectionsKt.flatten((Iterable)children.values());
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chapter chapter = (Chapter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ParentId parentId = (ParentId)it.getId();
                    if (parentId == null) {
                        throw new ParentNotFoundException(null, 1, null);
                    }
                    collection.add(parentId);
                }
                nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                ++depth;
            }
            n = var2_2;
        } else {
            n = 0;
        }
        return n;
    }

    public void checkMaxNestingDepthOfNewChapter(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        int parentChaptersNestingDepth = this.getAncestors(parentId).size() - 1;
        this.checkMaxNestingDepth(parentChaptersNestingDepth, 1);
    }

    private void checkMaxNestingDepth(int parentChaptersNestingDepth, int childrenChaptersNestingDepth) {
        if (parentChaptersNestingDepth + childrenChaptersNestingDepth > this.maxChapterDepth) {
            throw new ChapterNestingException("Maximum chapter nesting level " + this.maxChapterDepth + " reached");
        }
    }

    private void checkCircularAncestry(List<AncestorDto> parentAncestors, AbstractId movedElement) {
        boolean hasCircularAncestry;
        block4: {
            boolean bl;
            Iterable $this$any$iv = parentAncestors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AncestorDto it = (AncestorDto)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)movedElement)) continue;
                    bl = true;
                    break block4;
                }
                bl = hasCircularAncestry = false;
            }
        }
        if (hasCircularAncestry) {
            throw new CircularyAncestryException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getNextPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMax = n != null ? n : -1;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMax = n2 != null ? n2 : -1;
        return Math.max(chapterPositionMax, articlePositionMax) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getPreviousPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMin = n != null ? n : 0;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMin = n2 != null ? n2 : 0;
        return Math.min(chapterPositionMin, articlePositionMin) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Chapter> getDescendantChapters(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Chapter it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                UUID it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Chapter it = (Chapter)element$iv$iv;
                boolean bl2 = false;
                ChapterId chapterId = it.getId();
                if ((chapterId != null ? chapterId.getId() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(AncestorService $this) {
        return $this.applicationEventPublisher;
    }
}

