/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.authorization;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.authorization.model.PermissionAction;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.business.exceptions.NotFoundException;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.extension.MapExtensionKt;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u00010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ+\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\r0\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0010J\u0014\u0010\u001f\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0010J\u0014\u0010&\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!J\u001e\u0010'\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0010J\u0014\u0010+\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!J2\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u000e0\u001a\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\r0\u001aH\u0002J2\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u000e0\u001a\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\r0\u001aH\u0002J!\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0001\u00a2\u0006\u0002\b/R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/wikiservice/authorization/AuthContext;", "", "user", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "(Lde/justsoftware/wikiservice/model/ProfileId;Lde/justsoftware/wikiservice/model/TenantId;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;)V", "roleCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "tenantCache", "Lde/justsoftware/wikiservice/model/WikiId;", "getTenantId", "()Lde/justsoftware/wikiservice/model/TenantId;", "getUser", "()Lde/justsoftware/wikiservice/model/ProfileId;", "check", "", "ID", "Lde/justsoftware/wikiservice/model/AbstractId;", "roles", "", "check$wiki_service", "checkCreateWiki", "checkManageWiki", "wikiId", "checkManageWikis", "wikiIds", "", "checkMoveWikiContent", "fromWiki", "toWiki", "checkReadWiki", "checkReadWikis", "checkWikis", "permissionAction", "Lde/justsoftware/wikiservice/authorization/model/PermissionAction;", "checkWriteWiki", "checkWriteWikis", "getAndCacheRoles", "getAuthorizationResults", "getTenants", "getTenants$wiki_service", "Companion", "wiki-service"})
public final class AuthContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileId user;
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final Cache<Role, AuthorizationResult> roleCache;
    @NotNull
    private final Cache<WikiId, TenantId> tenantCache;
    private static final Logger log = LoggerFactory.getLogger(AuthContext.class);

    public AuthContext(@NotNull ProfileId user, @NotNull TenantId tenantId, @NotNull AuthorizationService authService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.user = user;
        this.tenantId = tenantId;
        this.authService = authService;
        this.wikiService = wikiService;
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder().build()");
        this.roleCache = cache;
        Cache cache2 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"newBuilder().build()");
        this.tenantCache = cache2;
    }

    @NotNull
    public final ProfileId getUser() {
        return this.user;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    public final void checkReadWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkReadWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkWriteWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkWriteWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkManageWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkManageWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkCreateWiki() {
        this.check$wiki_service(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.tenantId, (Object)Role.writeApp((CoreApp)CoreApp.WIKI, (UUID)this.tenantId.getId()))));
    }

    public final void checkReadWikis(@NotNull Set<? extends WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.READ);
    }

    public final void checkWriteWikis(@NotNull Set<? extends WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.WRITE);
    }

    public final void checkManageWikis(@NotNull Set<? extends WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.MANAGE);
    }

    public final void checkMoveWikiContent(@NotNull WikiId fromWiki, @NotNull WikiId toWiki) {
        Intrinsics.checkNotNullParameter((Object)fromWiki, (String)"fromWiki");
        Intrinsics.checkNotNullParameter((Object)toWiki, (String)"toWiki");
        Object[] objectArray = new WikiId[]{fromWiki, toWiki};
        if (this.getTenants$wiki_service(SetsKt.setOf((Object[])objectArray)).size() > 1) {
            throw new NotAllowedException("Moving articles or chapters between different tenants is not allowed");
        }
        objectArray = new WikiId[]{fromWiki, toWiki};
        this.checkWriteWikis(SetsKt.setOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkWikis(Set<? extends WikiId> wikiIds, PermissionAction permissionAction) {
        void $this$associateWith$iv;
        Role role;
        Map map;
        Object t;
        if (wikiIds.isEmpty()) {
            return;
        }
        Iterable $this$associateWith$iv2 = wikiIds;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv2;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void id;
            WikiId wikiId = (WikiId)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            role = Role.itemRole((String)permissionAction.name(), (String)id.toString());
            map.put(t, role);
        }
        Map actionRoles = result$iv;
        Iterable $i$f$associateWith22 = this.getTenants$wiki_service(wikiIds);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv2 = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void tenantId;
            TenantId bl = (TenantId)element$iv$iv;
            t = element$iv$iv;
            map = result$iv2;
            boolean bl2 = false;
            role = Role.tenantRead((UUID)tenantId.getId());
            map.put(t, role);
        }
        Map tenantRoles = result$iv2;
        this.check$wiki_service(MapsKt.plus((Map)actionRoles, (Map)tenantRoles));
    }

    @VisibleForTesting
    public final <ID extends AbstractId> void check$wiki_service(@NotNull Map<ID, Role> roles) {
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Map $this$forEach$iv = this.getAuthorizationResults(roles);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry result = element$iv = iterator.next();
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[((AuthorizationResult)result.getValue()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug(result.getKey() + " does not exist");
                    }
                    throw new NotFoundException("Failed permission check on " + result.getKey());
                }
                default: {
                    if (log.isDebugEnabled()) {
                        Role failedRole = (Role)MapsKt.getValue(roles, result.getKey());
                        if (failedRole.isTenantRole()) {
                            log.debug(this.user + " is not part of tenant " + result.getKey());
                        } else {
                            log.debug(this.user + " is not allowed to " + failedRole);
                        }
                    }
                    throw new NotAllowedException("Failed permission check on " + result.getKey());
                }
            }
        }
    }

    private final <ID extends AbstractId> Map<ID, AuthorizationResult> getAuthorizationResults(Map<ID, Role> roles) {
        Map cachedRoleAuthResults2 = MapExtensionKt.mapValuesNotNull(roles, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        if (cachedRoleAuthResults2.size() == roles.size()) {
            if (log.isDebugEnabled()) {
                log.debug("Authorization check cache hit for roles " + roles.values());
            }
            return cachedRoleAuthResults2;
        }
        Map<ID, Role> $this$filterKeys$iv = roles;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ID, Role> result$iv = new LinkedHashMap<ID, Role>();
        for (Map.Entry<ID, Role> entry$iv : $this$filterKeys$iv.entrySet()) {
            AbstractId it = (AbstractId)entry$iv.getKey();
            boolean bl = false;
            if (!(!cachedRoleAuthResults2.containsKey(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map roleAuthResultToLoad = result$iv;
        Map loadedRoleAuthResults = this.getAndCacheRoles(roleAuthResultToLoad);
        Map allRoleAuthResults = MapsKt.plus((Map)loadedRoleAuthResults, (Map)cachedRoleAuthResults2);
        if (allRoleAuthResults.size() != roles.size()) {
            throw new NotFoundException("Failed to load all auth results");
        }
        return allRoleAuthResults;
    }

    /*
     * WARNING - void declaration
     */
    private final <ID extends AbstractId> Map<ID, AuthorizationResult> getAndCacheRoles(Map<ID, Role> roles) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map;
        Map $this$getAndCacheRoles_u24lambda_u245 = map = this.authService.hasRoles(roles, this.user);
        boolean bl = false;
        Map map2 = $this$getAndCacheRoles_u24lambda_u245;
        Cache cache = this.roleCache;
        boolean $i$f$mapKeys = false;
        void var8_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Role role = roles.get(it.getKey());
            Map map4 = map3;
            boolean bl3 = false;
            Object v = it$iv$iv.getValue();
            map4.put(role, v);
        }
        cache.putAll(destination$iv$iv);
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<TenantId> getTenants$wiki_service(@NotNull Set<? extends WikiId> wikiIds) {
        void $this$associateWith$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map map = this.tenantCache.getAllPresent((Iterable)wikiIds);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"tenantCache.getAllPresent(wikiIds)");
        Map cachedTenants = MapsKt.toMap((Map)map);
        if (cachedTenants.size() == wikiIds.size()) {
            if (log.isDebugEnabled()) {
                log.debug("Tenant cache hit for " + cachedTenants.values());
            }
            return CollectionsKt.toSet((Iterable)cachedTenants.values());
        }
        Iterable $this$filter$iv = wikiIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WikiId it = (WikiId)element$iv$iv;
            boolean bl = false;
            if (!(!cachedTenants.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List wikisToLoad = (List)destination$iv$iv;
        Map loadedWikis = this.wikiService.readByIds(CollectionsKt.toSet((Iterable)wikisToLoad));
        if (!((Collection)CollectionsKt.minus((Iterable)wikisToLoad, (Iterable)loadedWikis.keySet())).isEmpty()) {
            throw new NotFoundException("Failed to load all wikis to get their tenants");
        }
        $this$filterTo$iv$iv = wikisToLoad;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            TenantId tenantId = ((WikiDto)MapsKt.getValue((Map)loadedWikis, (Object)it)).getTenantId();
            map2.put(t, tenantId);
        }
        Map loadedWikiTenants = result$iv;
        if (log.isDebugEnabled()) {
            log.debug("Tenant cache miss for " + loadedWikiTenants.values());
        }
        this.tenantCache.putAll(loadedWikiTenants);
        return SetsKt.plus((Set)CollectionsKt.toSet((Iterable)cachedTenants.values()), (Iterable)loadedWikiTenants.values());
    }

    public static final /* synthetic */ Cache access$getRoleCache$p(AuthContext $this) {
        return $this.roleCache;
    }
}

