/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "(Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/SubscriptionService;)V", "isManager", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "user", "Lde/justsoftware/wikiservice/model/ProfileId;", "isSubscribed", "Lde/justsoftware/wikiservice/model/ItemId;", "itemIds", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "isWriter", "wiki-service"})
public class UserInfoApplicationService {
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final SubscriptionService subscriptionService;

    @Autowired
    public UserInfoApplicationService(@NotNull AuthorizationService authorizationService, @NotNull SubscriptionService subscriptionService) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        this.authorizationService = authorizationService;
        this.subscriptionService = subscriptionService;
    }

    @NotNull
    public Map<WikiId, Boolean> isManager(@NotNull List<? extends WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.authorizationService.mayManageWikis(CollectionsKt.toSet((Iterable)wikiIds), user);
    }

    @NotNull
    public Map<WikiId, Boolean> isWriter(@NotNull List<? extends WikiId> wikiIds, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return wikiIds.isEmpty() ? MapsKt.emptyMap() : this.authorizationService.mayWriteWikis(CollectionsKt.toSet((Iterable)wikiIds), user);
    }

    @NotNull
    public Map<ItemId, Boolean> isSubscribed(@NotNull List<? extends ItemId> itemIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (itemIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Set set = CollectionsKt.toSet((Iterable)itemIds);
            Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type kotlin.collections.Set<de.justsoftware.wikiservice.model.WikiId>");
            authContext.checkReadWikis(set);
            map = this.subscriptionService.getIsSubscribedForItems(CollectionsKt.toSet((Iterable)itemIds), authContext.getUser());
        }
        return map;
    }
}

