/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.session.configuration;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;

@Configuration
@Profile(value={"production"})
@EnableRedisHttpSession
@ParametersAreNonnullByDefault
public class RedisSessionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSessionConfiguration.class);

    @Nonnull
    @Bean(name={"springSessionDefaultRedisSerializer"})
    public RedisSerializer<Object> springSessionDefaultRedisSerializer() {
        return new JdkSerializationRedisSerializer(){

            public Object deserialize(byte[] bytes) {
                try {
                    return super.deserialize(bytes);
                }
                catch (SerializationException e) {
                    LOG.warn("error during session deserialization, returning null", (Throwable)e);
                    return null;
                }
            }
        };
    }

    @Nonnull
    @Bean(name={"springSessionRedisTaskExecutor"})
    public ThreadPoolTaskExecutor springSessionRedisTaskExecutor(@Value(value="${redis.tomcatSessionTaskExecutor.corePoolSize:5}") int corePoolSize, @Value(value="${redis.tomcatSessionTaskExecutor.maxPoolSize:50}") int maxPoolSize, @Value(value="${redis.tomcatSessionTaskExecutor.queueCapacity:100}") int queueCapacity) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setThreadNamePrefix("redis-session-");
        return executor;
    }

    @Nonnull
    @Bean(name={"springSessionRedisSubscriptionExecutor"})
    public ThreadPoolTaskExecutor springSessionRedisSubscriptionExecutor(@Value(value="${redis.tomcatSessionSubscriptionExecutor.corePoolSize:5}") int corePoolSize, @Value(value="${redis.tomcatSessionSubscriptionExecutor.maxPoolSize:50}") int maxPoolSize, @Value(value="${redis.tomcatSessionSubscriptionExecutor.queueCapacity:100}") int queueCapacity) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setThreadNamePrefix("redis-session-subscription-");
        return executor;
    }

    @Nonnull
    @Bean(name={"redisTomcatSessionClient"})
    public RedisConnectionFactory jedisConnectionFactory(@Value(value="${redis.tomcatSession.host}") String redisHost, @Value(value="${redis.tomcatSession.port}") int redisPort, @Value(value="${redis.tomcatSession.password}") String redisPassword) {
        JedisConnectionFactory connectionFactory = new JedisConnectionFactory();
        connectionFactory.setHostName(redisHost);
        connectionFactory.setPort(redisPort);
        connectionFactory.setPassword(redisPassword);
        return connectionFactory;
    }

    @Nonnull
    @Bean(name={"httpSessionEventPublisher"})
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }
}

