/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.token.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.justsoftware.jackson2.JsonSerdesUtil;
import java.io.IOException;
import java.util.function.Function;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class OAuth2RequestDeserializer
extends JsonDeserializer<OAuth2Request> {
    public OAuth2Request deserialize(JsonParser jp, DeserializationContext ctxt) throws JsonProcessingException, IOException {
        JsonNode jsonNode = JsonSerdesUtil.readTree(jp);
        return new OAuth2Request(JsonSerdesUtil.readMap(jsonNode, "requestParameters", Function.identity(), JsonSerdesUtil::readString), JsonSerdesUtil.readStringNonnull(jsonNode, "clientId"), JsonSerdesUtil.readSet(jsonNode, "authorities", value -> new SimpleGrantedAuthority(JsonSerdesUtil.readString(value))), JsonSerdesUtil.readBooleanNonnull(jsonNode, "approved"), JsonSerdesUtil.readSet(jsonNode, "scope", JsonNode::asText), JsonSerdesUtil.readSet(jsonNode, "resourceIds", JsonSerdesUtil::readString), JsonSerdesUtil.readString(jsonNode, "redirectUri"), JsonSerdesUtil.readSet(jsonNode, "responseTypes", JsonSerdesUtil::readString), JsonSerdesUtil.readMap(jsonNode, "extensions", Function.identity(), JsonSerdesUtil::tryReadSerializable));
    }
}

