/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.jwtfilter.JwtClaimsHolder;
import de.justsoftware.onx.security.model.JustConnectUser;
import java.time.Instant;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.authentication.AbstractAuthenticationToken;

@ParametersAreNonnullByDefault
public class JustConnectUserAuthenticationToken
extends AbstractAuthenticationToken
implements JwtClaimsHolder {
    private static final long serialVersionUID = 1L;
    private final JustConnectUser _user;
    private final ImmutableMap<String, Object> _customJwtClaims;
    private final Instant _expirationTime;

    public JustConnectUserAuthenticationToken(@Nullable JustConnectUser user, @Nullable String tenantId) {
        this(user, null, (ImmutableMap<String, Object>)(Strings.isNullOrEmpty((String)tenantId) ? ImmutableMap.of() : ImmutableMap.of((Object)"tenantId", (Object)tenantId)));
    }

    public JustConnectUserAuthenticationToken(@Nullable JustConnectUser user, @Nullable Instant expirationTime, ImmutableMap<String, Object> customJwtClaims) {
        super((Collection)(user != null ? user.getAuthorities() : ImmutableSet.of()));
        this._user = user;
        this._expirationTime = expirationTime;
        this._customJwtClaims = customJwtClaims;
    }

    public String getCredentials() {
        return null;
    }

    public JustConnectUser getPrincipal() {
        return this._user;
    }

    public ImmutableMap<String, Object> getCustomJwtClaims() {
        return this._customJwtClaims;
    }

    public String getSubject() {
        return "PROFILE," + this._user.getId();
    }

    @CheckForNull
    public String getTenantId() {
        return (String)this._customJwtClaims.get((Object)"tenantId");
    }

    public boolean isAuthenticated() {
        return this._user != null && this._user.isAccountNonExpired() && this._user.isAccountNonLocked() && this._user.isEnabled() && this._user.isCredentialsNonExpired();
    }

    public Instant getExpirationTime() {
        return this._expirationTime;
    }
}

