/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.model;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

@ParametersAreNonnullByDefault
public class JustConnectUser
implements UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = 5L;
    private final long _id;
    private final String _username;
    private final Collection<? extends GrantedAuthority> _authorities;
    private final boolean _accountNonExpired;
    private final boolean _accountNonLocked;
    private final boolean _credentialsNonExpired;
    private final boolean _enabled;
    @Nullable
    private String _password;

    public JustConnectUser(long id, String username, @Nullable String password, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this(id, username, password, AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}), accountNonExpired, accountNonLocked, credentialsNonExpired, enabled);
    }

    public JustConnectUser(long id, String username, @Nullable String password, Collection<? extends GrantedAuthority> authorities, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this._id = id;
        this._username = username;
        this._password = password;
        this._authorities = authorities;
        this._accountNonExpired = accountNonExpired;
        this._accountNonLocked = accountNonLocked;
        this._credentialsNonExpired = credentialsNonExpired;
        this._enabled = enabled;
    }

    public long getId() {
        return this._id;
    }

    public void setPassword(@Nullable String password) {
        this._password = password;
    }

    public void eraseCredentials() {
        this._password = null;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this._authorities;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUsername() {
        return this._username;
    }

    public boolean isAccountNonExpired() {
        return this._accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this._accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this._credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int hashCode() {
        return Objects.hash(this._id, this._username);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JustConnectUser && this._id == ((JustConnectUser)obj)._id && Objects.equals(this._username, ((JustConnectUser)obj)._username);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this._id).add("username", (Object)this.getUsername()).add("authorities", this.getAuthorities()).add("accountNonExpired", this.isAccountNonExpired()).add("accountNonLocked", this.isAccountNonLocked()).add("credentialsNonExpired", this.isCredentialsNonExpired()).add("enabled", this.isEnabled()).toString();
    }
}

