/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.tracking;

import de.justsoftware.searchltr.persistence.DBSearchResult;
import de.justsoftware.searchltr.persistence.SearchResultRepository;
import de.justsoftware.searchltr.tracking.TrackingMessage;
import de.justsoftware.searchltr.tracking.TrackingMessageSearchResult;
import de.justsoftware.searchltr.tracking.TrackingMessageService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/searchltr/tracking/TrackingMessageService;", "", "searchResultRepository", "Lde/justsoftware/searchltr/persistence/SearchResultRepository;", "(Lde/justsoftware/searchltr/persistence/SearchResultRepository;)V", "handleOpenResultMessage", "", "message", "Lde/justsoftware/searchltr/tracking/TrackingMessage;", "handleSearchMessage", "handleTrackingMessage", "normalizeQuery", "", "query", "Companion", "search-ltr"})
public class TrackingMessageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchResultRepository searchResultRepository;
    private static final Logger LOG = LoggerFactory.getLogger(TrackingMessageService.class);

    public TrackingMessageService(@NotNull SearchResultRepository searchResultRepository) {
        Intrinsics.checkNotNullParameter((Object)searchResultRepository, (String)"searchResultRepository");
        this.searchResultRepository = searchResultRepository;
    }

    @Transactional
    public void handleTrackingMessage(@NotNull TrackingMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (Instant.now().toEpochMilli() - message.getTimestamp().toEpochMilli() > 31536000000L) {
            LOG.debug("Skip search tracking message from " + message.getTimestamp() + " for being too old");
            return;
        }
        String string = message.getAction();
        if (Intrinsics.areEqual((Object)string, (Object)"USER_PERFORM_SEARCH")) {
            this.handleSearchMessage(message);
        } else if (Intrinsics.areEqual((Object)string, (Object)"USER_OPEN_RESULT")) {
            this.handleOpenResultMessage(message);
        } else {
            LOG.debug("Skip search tracking message with unknown action " + message.getAction());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleSearchMessage(TrackingMessage message) {
        v0 = message.getNumberOfResults();
        if (v0 != null && v0 == 0) ** GOTO lbl-1000
        v1 = message.getResults();
        v2 = v1 != null ? v1.isEmpty() : false;
        if (v2) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = hasNoSearchResults = false;
        }
        if (hasNoSearchResults) {
            TrackingMessageService.LOG.debug("Skip search tracking message without search results");
            return;
        }
        v4 = message.getResults();
        Intrinsics.checkNotNull((Object)v4);
        hasMissingFeatureVector = ((TrackingMessageSearchResult)v4.get(0)).getFeatures().isEmpty();
        if (hasMissingFeatureVector) {
            TrackingMessageService.LOG.debug("Skip search tracking message with empty or missing feature vector");
            return;
        }
        TrackingMessageService.LOG.debug("Received search tracking message with id " + message.getSearchTrackingId() + " and " + message.getNumberOfResults() + " result(s)");
        now = Instant.now();
        $this$mapIndexed$iv = message.getResults();
        $i$f$mapIndexed = false;
        var8_7 = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        $i$f$mapIndexedTo = false;
        index$iv$iv = 0;
        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
            if ((var14_13 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var15_14 = (TrackingMessageSearchResult)item$iv$iv;
            var16_15 = var14_13;
            var18_17 = destination$iv$iv;
            $i$a$-mapIndexed-TrackingMessageService$handleSearchMessage$searchResults$1 = false;
            v5 = message.getSearchTrackingId();
            v6 = result.getId();
            v7 = message.getTimestamp();
            v8 = message.getQuery();
            Intrinsics.checkNotNull((Object)v8);
            v9 = this.normalizeQuery(v8);
            v10 = message.getTypeFilter();
            Intrinsics.checkNotNull((Object)v10);
            v11 = message.getSearchContext();
            Intrinsics.checkNotNull((Object)v11);
            v12 = message.getSearchContextId();
            v13 = message.getNumberOfResults();
            Intrinsics.checkNotNull((Object)v13);
            v14 = v13;
            v15 = message.getUserRoles();
            Intrinsics.checkNotNull((Object)v15);
            v16 = message.getOffset();
            Intrinsics.checkNotNull((Object)v16);
            v17 = v16 + index;
            v18 = result.getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
            var18_17.add(new DBSearchResult(v5, v6, v7, v9, v10, v11, v12, v14, v15, v17, false, v18, null, false, now, now));
        }
        searchResults = (List)destination$iv$iv;
        this.searchResultRepository.saveAllAndFlush((Iterable)searchResults);
    }

    private String normalizeQuery(String query) {
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.replace$default((String)string, (String)"\\s+", (String)" ", (boolean)false, (int)4, null);
    }

    private void handleOpenResultMessage(TrackingMessage message) {
        LOG.debug("Received search tracking message indicating result " + message.getSearchResultId() + " of query " + message.getSearchTrackingId() + " has been clicked");
        UUID uUID = message.getSearchTrackingId();
        String string = message.getSearchResultId();
        Intrinsics.checkNotNull((Object)string);
        this.searchResultRepository.setClicked(uUID, string);
    }
}

