/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.tracking;

import de.justsoftware.searchltr.tracking.TrackingMessage;
import de.justsoftware.searchltr.tracking.TrackingMessageKafkaConsumer;
import de.justsoftware.searchltr.tracking.TrackingMessageService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/searchltr/tracking/TrackingMessageKafkaConsumer;", "", "trackingMessageService", "Lde/justsoftware/searchltr/tracking/TrackingMessageService;", "(Lde/justsoftware/searchltr/tracking/TrackingMessageService;)V", "listen", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/searchltr/tracking/TrackingMessage;", "Companion", "search-ltr"})
public class TrackingMessageKafkaConsumer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TrackingMessageService trackingMessageService;
    @NotNull
    private static final Logger LOG;

    public TrackingMessageKafkaConsumer(@NotNull TrackingMessageService trackingMessageService) {
        Intrinsics.checkNotNullParameter((Object)trackingMessageService, (String)"trackingMessageService");
        this.trackingMessageService = trackingMessageService;
    }

    @KafkaListener(id="just.search.ltr.trackingMessageConsumer", containerFactory="trackingMessageListenerContainerFactory", topics={"just.search.ltr.tracking"})
    public void listen(@NotNull ConsumerRecords<String, TrackingMessage> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                Object object = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.value()");
                this.trackingMessageService.handleTrackingMessage((TrackingMessage)object);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process search tracking record with id '" + record.key() + "'.' Skip this record.", (Throwable)e);
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

