/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.solr;

import de.justsoftware.searchltr.solr.SolrClient;
import de.justsoftware.searchltr.solr.Solrs;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/searchltr/solr/SolrHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "solrs", "Lde/justsoftware/searchltr/solr/Solrs;", "(Lde/justsoftware/searchltr/solr/Solrs;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "search-ltr"})
public class SolrHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final Solrs solrs;

    public SolrHealthIndicator(@NotNull Solrs solrs) {
        Intrinsics.checkNotNullParameter((Object)solrs, (String)"solrs");
        super("Solr ping health check failed");
        this.solrs = solrs;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterator iterator = this.solrs.getAllSolrClients().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            SolrClient client = (SolrClient)iterator.next();
            if (index == 0) {
                builder.withDetail("leader", (Object)client.getCommonCoreUrl());
                continue;
            }
            builder.withDetail("replica" + (index - 1), (Object)client.getCommonCoreUrl());
        }
        try {
            Iterable $this$forEach$iv = this.solrs.getAllSolrClients();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SolrClient it = (SolrClient)element$iv;
                boolean bl = false;
                if (it.ping()) continue;
                builder.status(Status.DOWN);
                return;
            }
            builder.status(Status.UP);
        }
        catch (Exception e) {
            builder.status(Status.DOWN).withDetail("error", (Object)e.getMessage());
        }
    }
}

