/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.config.kafka;

import de.justsoftware.searchltr.config.kafka.KafkaTopicCleanupService;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/justsoftware/searchltr/config/kafka/KafkaTopicCleanupService;", "Lorg/springframework/beans/factory/InitializingBean;", "bootstrapServers", "", "(Ljava/lang/String;)V", "afterPropertiesSet", "", "Companion", "search-ltr"})
public class KafkaTopicCleanupService
implements InitializingBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private static final int LISTING_TIMEOUT = 10;
    @NotNull
    private static final String TOPIC_TO_CLEANUP = "just.search.ltr";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTopicCleanupService.class);

    public KafkaTopicCleanupService(@Value(value="${kafka.bootstrapServers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Map config = MapsKt.mapOf((Pair)TuplesKt.to((Object)"bootstrap.servers", (Object)this.bootstrapServers));
        try {
            AutoCloseable autoCloseable = (AutoCloseable)KafkaAdminClient.create((Map)config);
            Throwable throwable = null;
            try {
                AdminClient adminClient = (AdminClient)autoCloseable;
                boolean bl = false;
                ListTopicsResult listTopicsResult = adminClient.listTopics();
                Intrinsics.checkNotNullExpressionValue((Object)listTopicsResult, (String)"adminClient.listTopics()");
                ListTopicsResult result = listTopicsResult;
                boolean topicStillExists = ((Collection)result.listings().get(10L, TimeUnit.SECONDS)).stream().map(KafkaTopicCleanupService::afterPropertiesSet$lambda-2$lambda-0).anyMatch(KafkaTopicCleanupService::afterPropertiesSet$lambda-2$lambda-1);
                if (topicStillExists) {
                    LOG.info("Will delete the following old topic just.search.ltr");
                    adminClient.deleteTopics((Collection)CollectionsKt.listOf((Object)TOPIC_TO_CLEANUP));
                    LOG.info("Topic deleted successfully");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
    }

    private static final String afterPropertiesSet$lambda-2$lambda-0(TopicListing topic) {
        String string = topic.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topic.name()");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string2;
    }

    private static final boolean afterPropertiesSet$lambda-2$lambda-1(String topic) {
        return topic.equals(TOPIC_TO_CLEANUP);
    }
}

