/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.config;

import com.google.common.base.Charsets;
import de.justsoftware.searchltr.config.ZookeeperService;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0006H\u0012J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0012R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/searchltr/config/ZookeeperService;", "", "zookeeperClient", "Lorg/apache/curator/framework/CuratorFramework;", "(Lorg/apache/curator/framework/CuratorFramework;)V", "storeName", "", "modelName", "getModelName", "()Ljava/lang/String;", "setModelName", "(Ljava/lang/String;)V", "modelNameCache", "Lorg/apache/curator/framework/recipes/cache/NodeCache;", "upcomingFeatureStoreNameCache", "upcomingFeaturesStoreName", "getUpcomingFeaturesStoreName", "setUpcomingFeaturesStoreName", "deleteNode", "kotlin.jvm.PlatformType", "node", "getString", "cache", "resetConfig", "", "storeInZookeeper", "path", "data", "Companion", "search-ltr"})
public class ZookeeperService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CuratorFramework zookeeperClient;
    @NotNull
    private final NodeCache upcomingFeatureStoreNameCache;
    @NotNull
    private final NodeCache modelNameCache;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String UPCOMING_FEATURES_STORE_NAME_PATH = "/just/search/ltr/featureStoreName/justSearchUpcomingFeatureStore";
    @NotNull
    private static final String MODEL_NAME_PATH = "/just/search/ltr/modelStoreName/justSearchModel";

    /*
     * WARNING - void declaration
     */
    public ZookeeperService(@NotNull CuratorFramework zookeeperClient) {
        void $this$modelNameCache_u24lambda_u2d1;
        NodeCache $this$upcomingFeatureStoreNameCache_u24lambda_u2d0;
        NodeCache nodeCache;
        Intrinsics.checkNotNullParameter((Object)zookeeperClient, (String)"zookeeperClient");
        this.zookeeperClient = zookeeperClient;
        NodeCache nodeCache2 = nodeCache = new NodeCache(this.zookeeperClient, UPCOMING_FEATURES_STORE_NAME_PATH);
        ZookeeperService zookeeperService = this;
        boolean bl = false;
        $this$upcomingFeatureStoreNameCache_u24lambda_u2d0.start();
        zookeeperService.upcomingFeatureStoreNameCache = nodeCache;
        $this$upcomingFeatureStoreNameCache_u24lambda_u2d0 = nodeCache = new NodeCache(this.zookeeperClient, MODEL_NAME_PATH);
        zookeeperService = this;
        boolean bl2 = false;
        $this$modelNameCache_u24lambda_u2d1.start();
        zookeeperService.modelNameCache = nodeCache;
    }

    @Nullable
    public String getUpcomingFeaturesStoreName() {
        return this.getString(this.upcomingFeatureStoreNameCache);
    }

    public void setUpcomingFeaturesStoreName(@Nullable String storeName) {
        String string = storeName;
        Intrinsics.checkNotNull((Object)string);
        this.storeInZookeeper(UPCOMING_FEATURES_STORE_NAME_PATH, string);
    }

    @Nullable
    public String getModelName() {
        return this.getString(this.modelNameCache);
    }

    public void setModelName(@Nullable String storeName) {
        String string = storeName;
        Intrinsics.checkNotNull((Object)string);
        this.storeInZookeeper(MODEL_NAME_PATH, string);
    }

    public void resetConfig() {
        this.deleteNode(UPCOMING_FEATURES_STORE_NAME_PATH);
        this.deleteNode(MODEL_NAME_PATH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getString(NodeCache cache) {
        ChildData childData = cache.getCurrentData();
        Object object = childData;
        if (childData == null) return null;
        byte[] byArray = object.getData();
        object = byArray;
        if (byArray == null) return null;
        Object object2 = object;
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string = new String((byte[])object2, charset2);
        return string;
    }

    private Object deleteNode(String node) {
        Object object;
        try {
            object = this.zookeeperClient.delete().forPath(node);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info("Node " + node + " does not exists. Skip deleting node.");
            object = Unit.INSTANCE;
        }
        return object;
    }

    private void storeInZookeeper(String path, String data) {
        Object object = this.zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"zookeeperClient\n        \u2026de(CreateMode.PERSISTENT)");
        ACLBackgroundPathAndBytesable createBuilder = (ACLBackgroundPathAndBytesable)object;
        try {
            String string = data;
            Charset charset = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            createBuilder.forPath(path, byArray);
            LOG.info("Successfully created Zookeeper path: " + path);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                SetDataBuilder setDataBuilder = this.zookeeperClient.setData();
                Intrinsics.checkNotNullExpressionValue((Object)setDataBuilder, (String)"zookeeperClient.setData()");
                SetDataBuilder updateBuilder = setDataBuilder;
                String string = data;
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                updateBuilder.forPath(path, byArray);
                LOG.info("Successfully updated Zookeeper path: " + path);
            }
            catch (Exception e1) {
                LOG.warn("Failed to update path in Zookeeper: " + path + " ", (Throwable)e1);
                throw e1;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create path in Zookeeper: " + path + " ", (Throwable)e);
            throw e;
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

