/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.searchltr.LTRFeatureConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/searchltr/ToroAPI;", "", "toroInternalUrl", "", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getLTRFeatureConfiguration", "Lde/justsoftware/searchltr/LTRFeatureConfiguration;", "search-ltr"})
public class ToroAPI {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestTemplate rest;
    @NotNull
    private final ObjectMapper mapper;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public ToroAPI(@Value(value="${toro.internal.baseUrl}") @NotNull String toroInternalUrl, @NotNull RestTemplate rest) {
        void $this$mapper_u24lambda_u2d0;
        ObjectMapper objectMapper;
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroInternalUrl = toroInternalUrl;
        this.rest = rest;
        ObjectMapper objectMapper2 = objectMapper = new ObjectMapper();
        ToroAPI toroAPI = this;
        boolean bl = false;
        $this$mapper_u24lambda_u2d0.registerModule((Module)new JodaModule());
        $this$mapper_u24lambda_u2d0.registerModule((Module)new KotlinModule.Builder().build());
        $this$mapper_u24lambda_u2d0.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        toroAPI.mapper = objectMapper;
    }

    public /* synthetic */ ToroAPI(String string, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, restTemplate);
    }

    @NotNull
    public LTRFeatureConfiguration getLTRFeatureConfiguration() {
        ResponseEntity it = this.rest.getForEntity(this.toroInternalUrl + "/ltr/config", String.class, new Object[0]);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            throw new IllegalStateException(("Failed to retrieve LTR configuration: " + it.getStatusCode()).toString());
        }
        Object object = this.mapper.readValue((String)it.getBody(), LTRFeatureConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(it.body\u2026onfiguration::class.java)");
        return (LTRFeatureConfiguration)object;
    }
}

