/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.rest.context;

import de.justsoftware.permission.rest.context.PermissionApiExceptionHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
@ParametersAreNonnullByDefault
public class PermissionApiExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String LOG_MESSAGE = "REST-API call throws exception ({})";
    private static final Random RNG = new Random(System.currentTimeMillis());
    private static final Logger LOG = LoggerFactory.getLogger(PermissionApiExceptionHandler.class);

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<Error> handleException(Exception e) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        return PermissionApiExceptionHandler.handleError((Error)new Error(HttpStatus.INTERNAL_SERVER_ERROR), (Throwable)e);
    }

    @Nonnull
    private static ResponseEntity<Error> handleError(Error error, Throwable e) {
        LOG.error("REST-API call throws exception ({})", (Object)error.getUid(), (Object)e);
        return new ResponseEntity((Object)error, error.getResponseCode());
    }
}

