/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence.h2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.ProfileRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.persistence.DAOSupport;
import de.justsoftware.permission.persistence.RoleDAO;
import de.justsoftware.permission.persistence.SqlBuilder;
import de.justsoftware.permission.persistence.TransactionSupport;
import de.justsoftware.toolbox.ObjectUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@ParametersAreNonnullByDefault
public class H2RoleDAO
implements RoleDAO {
    private final DAOSupport _daoSupport;
    private final TransactionSupport _transactionSupport;
    private final JdbcTemplate _jdbcTemplate;

    @Autowired
    public H2RoleDAO(DAOSupport daoSupport, TransactionSupport transactionSupport, JdbcTemplate jdbcTemplate) {
        this._daoSupport = daoSupport;
        this._transactionSupport = transactionSupport;
        this._jdbcTemplate = jdbcTemplate;
    }

    public void storeRoleReplacements(Table<? extends DirectlyResolvableRole, Role, Optional<Boolean>> replacements) {
        this._transactionSupport.doInTransaction(() -> {
            this._daoSupport.batchUpdate("DELETE FROM role_replacement WHERE role = ? AND replacement = ?", (Iterable)replacements.cellSet(), (Iterable)ImmutableList.of(cell -> ((DirectlyResolvableRole)ObjectUtil.checkNotNull((Object)((DirectlyResolvableRole)cell.getRowKey()))).name(), cell -> ((Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()))).name()));
            this._daoSupport.batchUpdate("INSERT INTO role_replacement(role, replacement, allowed) VALUES(?,?,?)", (Iterable)Sets.filter((Set)replacements.cellSet(), cell -> ((Optional)ObjectUtil.checkNotNull((Object)((Optional)cell.getValue()))).isPresent()), (Iterable)ImmutableList.of(cell -> ((DirectlyResolvableRole)ObjectUtil.checkNotNull((Object)((DirectlyResolvableRole)cell.getRowKey()))).name(), cell -> ((Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()))).name(), cell -> ((Optional)ObjectUtil.checkNotNull((Object)((Optional)cell.getValue()))).get()));
        });
    }

    public void replaceRoleReplacements(Map<? extends DirectlyResolvableRole, Replacement> replacements) {
        this._transactionSupport.doInTransaction(() -> {
            this._daoSupport.batchUpdate("DELETE FROM role_replacement WHERE role = ?", replacements.entrySet(), (Iterable)ImmutableList.of(e -> ((DirectlyResolvableRole)e.getKey()).name()));
            String sql = "INSERT INTO role_replacement(role, replacement, allowed) VALUES(?,?,?)";
            LinkedList batchArgs = new LinkedList();
            replacements.forEach((role, replacement) -> {
                replacement.getAllowed().forEach(value -> batchArgs.add(new Object[]{role.name(), value.name(), Boolean.TRUE}));
                replacement.getForbidden().forEach(value -> batchArgs.add(new Object[]{role.name(), value.name(), Boolean.FALSE}));
            });
            this._jdbcTemplate.batchUpdate("INSERT INTO role_replacement(role, replacement, allowed) VALUES(?,?,?)", batchArgs);
        });
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this.getReplacementsInternal(roles, false);
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getNonProfileReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this.getReplacementsInternal(roles, true);
    }

    @Nonnull
    private ImmutableMap<DirectlyResolvableRole, Replacement> getReplacementsInternal(Set<? extends DirectlyResolvableRole> roles, boolean filterProfiles) {
        ImmutableSetMultimap.Builder allowedRolesBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder forbiddenRolesBuilder = ImmutableSetMultimap.builder();
        SqlBuilder sql = this._daoSupport.prep("SELECT role, replacement, allowed FROM role_replacement WHERE role IN (").appendParams(",", roles.stream().map(Role::name)).append(") ", new Object[0]);
        if (filterProfiles) {
            sql.append("AND (allowed = FALSE OR replacement NOT LIKE 'PROFILE,%')", new Object[0]);
        }
        sql.forEachRow(rs -> {
            ImmutableSetMultimap.Builder targetMap = rs.getBoolean("allowed") ? allowedRolesBuilder : forbiddenRolesBuilder;
            targetMap.put((Object)H2RoleDAO.roleCol((ResultSet)rs), (Object)H2RoleDAO.replacementCol((ResultSet)rs));
        });
        ImmutableSetMultimap allowedRoles = allowedRolesBuilder.build();
        ImmutableSetMultimap forbiddenRoles = forbiddenRolesBuilder.build();
        return (ImmutableMap)roles.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), r -> new Replacement((Set)allowedRoles.get(r), (Set)forbiddenRoles.get(r))));
    }

    public ImmutableSetMultimap<Role, DirectlyResolvableRole> getInverseAllowedReplacements(Set<? extends Role> replacements) {
        return this._daoSupport.prep("SELECT role, replacement FROM role_replacement WHERE replacement IN (").appendParams(",", replacements.stream().map(Role::name)).append(") AND allowed", new Object[0]).setMultimap(H2RoleDAO::replacementCol, H2RoleDAO::roleCol);
    }

    @Nonnull
    private static DirectlyResolvableRole roleCol(ResultSet rs) throws SQLException {
        return (DirectlyResolvableRole)Role.valueOf((String)rs.getString("role"));
    }

    @Nonnull
    private static Role replacementCol(ResultSet rs) throws SQLException {
        return Role.valueOf((String)rs.getString("replacement"));
    }

    public ImmutableSet<DirectlyResolvableRole> filterRolesForProfiles(Set<? extends DirectlyResolvableRole> rolesToResolve, Set<ProfileRole> profileRoles) {
        return this._daoSupport.prep("SELECT role FROM role_replacement WHERE role IN (").appendParams(",", rolesToResolve.stream().map(Role::name)).append(") AND replacement IN (", new Object[0]).appendParams(",", profileRoles.stream().map(Role::name)).append(") AND allowed", new Object[0]).set(H2RoleDAO::roleCol);
    }
}

