/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.CommentId;
import de.justsoftware.news.DocumentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.migrateditem.MigratedItemRepo;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollPrivacy;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.kafka.toromigration.PostMigrationAttachmentKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationCommentKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationPollAnswerKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationPollAnswerVoteKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationPollKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationReactionKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationService;
import de.justsoftware.news.util.TransactionSupport;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/kafka/toromigration/PostMigrationService;", "", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "migratedItemRepo", "Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;", "(Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;)V", "migratePost", "", "postDto", "Lde/justsoftware/news/kafka/toromigration/PostMigrationKafkaDto;", "Companion", "news-service"})
public class PostMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final MigratedItemRepo migratedItemRepo;
    @NotNull
    private static final Logger log;

    public PostMigrationService(@NotNull PostRepo postRepo, @NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull AttachmentRepo attachmentRepo, @NotNull PostCommentRepo postCommentRepo, @NotNull ReactionRepo reactionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher, @NotNull MigratedItemRepo migratedItemRepo) {
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)migratedItemRepo, (String)"migratedItemRepo");
        this.postRepo = postRepo;
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.attachmentRepo = attachmentRepo;
        this.postCommentRepo = postCommentRepo;
        this.reactionRepo = reactionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
        this.migratedItemRepo = migratedItemRepo;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migratePost(@NotNull PostMigrationKafkaDto postDto) {
        PostMigrationAttachmentKafkaDto it;
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)postDto, (String)"postDto");
        if (this.postRepo.findById((Object)postDto.getId()).isPresent()) {
            log.info("Skipping migration. {} already migrated", (Object)postDto.getId());
            return;
        }
        PostRepo postRepo = this.postRepo;
        PostId postId = postDto.getId();
        ProfileId profileId = postDto.getAuthorId();
        ChannelId channelId = postDto.getChannelId();
        Instant instant2 = Instant.ofEpochSecond(postDto.getCreateDate());
        Instant instant3 = instant2;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(postDto.createDate)");
        Instant instant4 = Instant.ofEpochSecond(postDto.getModifyDate());
        Instant instant5 = instant4;
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"ofEpochSecond(postDto.modifyDate)");
        String string = postDto.getTitle();
        String string2 = postDto.getText();
        String string3 = postDto.getJsonContent();
        DocumentId documentId = postDto.getCoverElementId();
        boolean bl = postDto.getPinned();
        Long l = postDto.getPinnedAt();
        if (l != null) {
            void it2;
            long l2 = ((Number)l).longValue();
            boolean bl2 = bl;
            DocumentId documentId2 = documentId;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            Instant instant6 = instant5;
            Instant instant7 = instant3;
            ChannelId channelId2 = channelId;
            ProfileId profileId2 = profileId;
            PostId postId2 = postId;
            PostRepo postRepo2 = postRepo;
            boolean bl3 = false;
            Instant instant8 = Instant.ofEpochSecond((long)it2);
            postRepo = postRepo2;
            postId = postId2;
            profileId = profileId2;
            channelId = channelId2;
            instant3 = instant7;
            instant5 = instant6;
            string = string6;
            string2 = string5;
            string3 = string4;
            documentId = documentId2;
            bl = bl2;
            instant = instant8;
        } else {
            instant = null;
        }
        Instant instant9 = Instant.ofEpochSecond(postDto.getPublishDate());
        Intrinsics.checkNotNullExpressionValue((Object)instant9, (String)"ofEpochSecond(postDto.publishDate)");
        PostRepo.insert$default((PostRepo)postRepo, (PostId)postId, (ProfileId)profileId, (ChannelId)channelId, (Instant)instant3, (Instant)instant5, (String)string, (String)string2, (String)string3, (DocumentId)documentId, (boolean)bl, instant, (Instant)instant9, (boolean)postDto.getPublished(), (boolean)false, (int)8192, null);
        Post post = this.postRepo.getByIdAndDeletedFalse(postDto.getId());
        if (postDto.getPoll() != null) {
            PostMigrationPollKafkaDto poll = postDto.getPoll();
            this.pollRepo.insert(poll.getId(), poll.getQuestion(), poll.getAllowMultipleAnswers(), post.getId(), PollPrivacy.PUBLIC);
            Iterable $this$forEach$iv = poll.getAnswers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PostMigrationPollAnswerKafkaDto answer = (PostMigrationPollAnswerKafkaDto)element$iv;
                boolean bl4 = false;
                this.pollAnswerRepo.insert(answer.getId(), answer.getText(), answer.getPosition(), poll.getId());
                List list = answer.getVotes();
                if (list != null) {
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        PostMigrationPollAnswerVoteKafkaDto vote = (PostMigrationPollAnswerVoteKafkaDto)element$iv2;
                        boolean bl5 = false;
                        this.pollVoteRepo.insert(vote.getId(), poll.getId(), answer.getId(), vote.getProfileId());
                    }
                }
            }
        }
        Iterable $this$forEach$iv = postDto.getAttachments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PostMigrationAttachmentKafkaDto)element$iv;
            boolean bl6 = false;
            this.attachmentRepo.insert(it.getId(), post.getId(), it.getMimeType(), it.getName(), (int)it.getFileSize(), it.getPosition());
        }
        $this$forEach$iv = postDto.getComments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Comparable<Long> comparable;
            Instant instant10;
            ProfileId profileId3;
            ItemId itemId;
            ItemId itemId2;
            PostId postId3;
            CommentId commentId;
            PostCommentRepo postCommentRepo;
            PostMigrationCommentKafkaDto comment;
            block17: {
                block16: {
                    void it3;
                    comment = (PostMigrationCommentKafkaDto)element$iv;
                    boolean bl7 = false;
                    postCommentRepo = this.postCommentRepo;
                    commentId = comment.getId();
                    postId3 = post.getId();
                    itemId2 = (ItemId)post.getId();
                    itemId = (ItemId)post.getId();
                    profileId3 = comment.getAuthorId();
                    Instant instant11 = Instant.ofEpochSecond(comment.getPostedAt());
                    instant10 = instant11;
                    Intrinsics.checkNotNullExpressionValue((Object)instant11, (String)"ofEpochSecond(comment.postedAt)");
                    comparable = comment.getEditedAt();
                    if (comparable == null) break block16;
                    long bl4 = ((Number)((Object)comparable)).longValue();
                    Instant instant12 = instant10;
                    ProfileId profileId4 = profileId3;
                    ItemId itemId3 = itemId;
                    ItemId itemId4 = itemId2;
                    PostId postId4 = postId3;
                    CommentId commentId2 = commentId;
                    PostCommentRepo postCommentRepo2 = postCommentRepo;
                    boolean bl8 = false;
                    Instant instant13 = Instant.ofEpochSecond((long)it3);
                    postCommentRepo = postCommentRepo2;
                    commentId = commentId2;
                    postId3 = postId4;
                    itemId2 = itemId4;
                    itemId = itemId3;
                    profileId3 = profileId4;
                    instant10 = instant12;
                    Instant instant14 = instant13;
                    comparable = instant14;
                    if (instant14 != null) break block17;
                }
                comparable = Instant.ofEpochSecond(comment.getPostedAt());
            }
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"comment.editedAt?.let { \u2026hSecond(comment.postedAt)");
            ProfileId profileId5 = comment.getEditorId();
            if (profileId5 == null) {
                profileId5 = comment.getAuthorId();
            }
            postCommentRepo.insert(commentId, postId3, itemId2, itemId, profileId3, instant10, (Instant)comparable, profileId5, comment.getJsonContent(), comment.getText());
        }
        $this$forEach$iv = postDto.getReactions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PostMigrationReactionKafkaDto)element$iv;
            boolean bl9 = false;
            this.reactionRepo.insert(it.getId(), ":thumbsup:", it.getItemId(), it.getProfileId());
        }
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(PostMigrationService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(PostMigrationService $this) {
        return $this.eventPublisher;
    }

    public static final /* synthetic */ MigratedItemRepo access$getMigratedItemRepo$p(PostMigrationService $this) {
        return $this.migratedItemRepo;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PostMigrationService::class.java)");
        log = logger;
    }
}

