/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.domain.maintenance.MaintenanceService;
import de.justsoftware.news.domain.migrateditem.MigratedItem;
import de.justsoftware.news.domain.migrateditem.MigratedItemRepo;
import de.justsoftware.news.domain.newscover.NewsCover;
import de.justsoftware.news.json.ItemIdDeserializer;
import de.justsoftware.news.json.UserIdDeserializer;
import de.justsoftware.news.kafka.KafkaMigrationProducer;
import de.justsoftware.news.kafka.toromigration.ChannelKafkaDto;
import de.justsoftware.news.kafka.toromigration.ChannelMigrationService;
import de.justsoftware.news.kafka.toromigration.KafkaToroMigrationConsumer;
import de.justsoftware.news.kafka.toromigration.MigrationErrorRepo;
import de.justsoftware.news.kafka.toromigration.NewsCoverMigrationService;
import de.justsoftware.news.kafka.toromigration.PostMigrationKafkaDto;
import de.justsoftware.news.kafka.toromigration.PostMigrationService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0017J\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0012J\u0014\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0012J\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/news/kafka/toromigration/KafkaToroMigrationConsumer;", "", "channelMigrationService", "Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;", "postMigrationService", "Lde/justsoftware/news/kafka/toromigration/PostMigrationService;", "newsCoverMigrationService", "Lde/justsoftware/news/kafka/toromigration/NewsCoverMigrationService;", "maintenanceService", "Lde/justsoftware/news/domain/maintenance/MaintenanceService;", "migratedItemRepo", "Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;", "migrationItemProducer", "Lde/justsoftware/news/kafka/KafkaMigrationProducer;", "migrationErrorRepo", "Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;", "(Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;Lde/justsoftware/news/kafka/toromigration/PostMigrationService;Lde/justsoftware/news/kafka/toromigration/NewsCoverMigrationService;Lde/justsoftware/news/domain/maintenance/MaintenanceService;Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;Lde/justsoftware/news/kafka/KafkaMigrationProducer;Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;)V", "migrationFinished", "", "getMigrationFinished", "()Z", "setMigrationFinished", "(Z)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "listen", "", "key", "", "payload", "parseChannel", "Lde/justsoftware/news/kafka/toromigration/ChannelKafkaDto;", "parseNewsCover", "Lde/justsoftware/news/domain/newscover/NewsCover;", "parsePost", "Lde/justsoftware/news/kafka/toromigration/PostMigrationKafkaDto;", "Companion", "news-service"})
public class KafkaToroMigrationConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelMigrationService channelMigrationService;
    @NotNull
    private final PostMigrationService postMigrationService;
    @NotNull
    private final NewsCoverMigrationService newsCoverMigrationService;
    @NotNull
    private final MaintenanceService maintenanceService;
    @NotNull
    private final MigratedItemRepo migratedItemRepo;
    @NotNull
    private final KafkaMigrationProducer migrationItemProducer;
    @NotNull
    private final MigrationErrorRepo migrationErrorRepo;
    private boolean migrationFinished;
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String MIGRATION_END = "MIGRATION_END";

    public KafkaToroMigrationConsumer(@NotNull ChannelMigrationService channelMigrationService, @NotNull PostMigrationService postMigrationService, @NotNull NewsCoverMigrationService newsCoverMigrationService, @NotNull MaintenanceService maintenanceService, @NotNull MigratedItemRepo migratedItemRepo, @NotNull KafkaMigrationProducer migrationItemProducer, @NotNull MigrationErrorRepo migrationErrorRepo) {
        Intrinsics.checkNotNullParameter((Object)channelMigrationService, (String)"channelMigrationService");
        Intrinsics.checkNotNullParameter((Object)postMigrationService, (String)"postMigrationService");
        Intrinsics.checkNotNullParameter((Object)newsCoverMigrationService, (String)"newsCoverMigrationService");
        Intrinsics.checkNotNullParameter((Object)maintenanceService, (String)"maintenanceService");
        Intrinsics.checkNotNullParameter((Object)migratedItemRepo, (String)"migratedItemRepo");
        Intrinsics.checkNotNullParameter((Object)migrationItemProducer, (String)"migrationItemProducer");
        Intrinsics.checkNotNullParameter((Object)migrationErrorRepo, (String)"migrationErrorRepo");
        this.channelMigrationService = channelMigrationService;
        this.postMigrationService = postMigrationService;
        this.newsCoverMigrationService = newsCoverMigrationService;
        this.maintenanceService = maintenanceService;
        this.migratedItemRepo = migratedItemRepo;
        this.migrationItemProducer = migrationItemProducer;
        this.migrationErrorRepo = migrationErrorRepo;
        this.migrationFinished = true;
        Module[] moduleArray = new Module[]{(Module)UserIdDeserializer.INSTANCE, (Module)ItemIdDeserializer.INSTANCE};
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(moduleArray);
    }

    public boolean getMigrationFinished() {
        return this.migrationFinished;
    }

    public void setMigrationFinished(boolean bl) {
        this.migrationFinished = bl;
    }

    @KafkaListener(containerFactory="toroMigrationListenerContainerFactory", topics={"just.toro.migration.news"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable String payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            this.setMigrationFinished(false);
            if (ChannelId.Companion.isValid(key)) {
                ChannelKafkaDto channelDto;
                ChannelKafkaDto channelKafkaDto = channelDto = this.parseChannel(payload);
                if (channelKafkaDto != null) {
                    ChannelKafkaDto it = channelKafkaDto;
                    boolean bl = false;
                    this.channelMigrationService.migrateChannel(channelDto);
                }
            } else if (PostId.Companion.isValid(key)) {
                PostMigrationKafkaDto postDto;
                PostMigrationKafkaDto postMigrationKafkaDto = postDto = this.parsePost(payload);
                if (postMigrationKafkaDto != null) {
                    PostMigrationKafkaDto it = postMigrationKafkaDto;
                    boolean bl = false;
                    this.postMigrationService.migratePost(postDto);
                }
            } else if (TenantId.Companion.isValid(key)) {
                NewsCover newsCover;
                NewsCover newsCover2 = newsCover = this.parseNewsCover(payload);
                if (newsCover2 != null) {
                    NewsCover it = newsCover2;
                    boolean bl = false;
                    this.newsCoverMigrationService.migrate(newsCover);
                }
            } else if (Intrinsics.areEqual((Object)key, (Object)MIGRATION_END)) {
                log.info("Migration end received.");
                this.maintenanceService.reIndexSearchForAllTenants();
                Iterable iterable = this.migratedItemRepo.findAll();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"migratedItemRepo\n       \u2026               .findAll()");
                Iterable $this$forEach$iv = iterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MigratedItem it = (MigratedItem)element$iv;
                    boolean bl = false;
                    this.migrationItemProducer.publishMigratedItem(it.getLegacyId(), it.getItemId());
                }
                this.setMigrationFinished(true);
            } else {
                String errorMsg = "Skipping message because key: '" + key + "' is not a ChannelId, PostId or TenantId.";
                MigrationErrorRepo.insert$default((MigrationErrorRepo)this.migrationErrorRepo, null, (String)key, (String)errorMsg, null, (int)9, null);
                log.warn(errorMsg);
            }
        }
        catch (Exception e) {
            MigrationErrorRepo migrationErrorRepo = this.migrationErrorRepo;
            String string = "Reason: " + e.getLocalizedMessage();
            MigrationErrorRepo.insert$default((MigrationErrorRepo)migrationErrorRepo, null, (String)key, (String)string, (String)payload, (int)1, null);
            log.warn("Failed to migrate message with key '" + key + "' and payload '" + payload + "'. Reason: " + e.getLocalizedMessage());
        }
    }

    private ChannelKafkaDto parseChannel(String payload) {
        return (ChannelKafkaDto)this.objectMapper.readValue(payload, ChannelKafkaDto.class);
    }

    private PostMigrationKafkaDto parsePost(String payload) {
        return (PostMigrationKafkaDto)this.objectMapper.readValue(payload, PostMigrationKafkaDto.class);
    }

    private NewsCover parseNewsCover(String payload) {
        return (NewsCover)this.objectMapper.readValue(payload, NewsCover.class);
    }

    static {
        Logger logger = LoggerFactory.getLogger(KafkaToroMigrationConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KafkaToroMigrationConsumer::class.java)");
        log = logger;
    }
}

