/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.toromigration;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.ManagedSubscriptionId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.migrateditem.MigratedItemRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.kafka.toromigration.ChannelKafkaDto;
import de.justsoftware.news.kafka.toromigration.ChannelMigrationService;
import de.justsoftware.news.kafka.toromigration.ChannelPermissionKafkaDto;
import de.justsoftware.news.kafka.toromigration.MigrationErrorRepo;
import de.justsoftware.news.kafka.toromigration.PersonalSubscriptionKafkaDto;
import de.justsoftware.news.util.TransactionSupport;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00160\u001eH\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/kafka/toromigration/ChannelMigrationService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "migratedItemRepo", "Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;", "migrationErrorRepo", "Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;)V", "addPermissions", "", "Lde/justsoftware/news/connector/permission/PermissionItem;", "permissionsDto", "Lde/justsoftware/news/kafka/toromigration/ChannelPermissionKafkaDto;", "channelId", "Lde/justsoftware/news/ChannelId;", "getLowestPermission", "usersWithMultiplePermissions", "", "Lde/justsoftware/news/UserId;", "migrateChannel", "", "channelDto", "Lde/justsoftware/news/kafka/toromigration/ChannelKafkaDto;", "Companion", "news-service"})
public class ChannelMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final MigratedItemRepo migratedItemRepo;
    @NotNull
    private final MigrationErrorRepo migrationErrorRepo;
    @NotNull
    private static final Logger log;

    public ChannelMigrationService(@NotNull ChannelRepo channelRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher, @NotNull MigratedItemRepo migratedItemRepo, @NotNull MigrationErrorRepo migrationErrorRepo) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)migratedItemRepo, (String)"migratedItemRepo");
        Intrinsics.checkNotNullParameter((Object)migrationErrorRepo, (String)"migrationErrorRepo");
        this.channelRepo = channelRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
        this.migratedItemRepo = migratedItemRepo;
        this.migrationErrorRepo = migrationErrorRepo;
    }

    @Transactional
    public void migrateChannel(@NotNull ChannelKafkaDto channelDto) {
        Intrinsics.checkNotNullParameter((Object)channelDto, (String)"channelDto");
        if (this.channelRepo.findById((Object)channelDto.getId()).isPresent()) {
            log.info("Skipping migration. {} already migrated", (Object)channelDto.getId());
            return;
        }
        ChannelId channelId = channelDto.getId();
        String string = channelDto.getTitle();
        TenantId tenantId = channelDto.getTenantId();
        Instant instant = Instant.ofEpochSecond(channelDto.getModifyDate());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(channelDto.modifyDate)");
        Instant instant2 = Instant.ofEpochSecond(channelDto.getCreateDate());
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(channelDto.createDate)");
        ChannelRepo.insert$default((ChannelRepo)this.channelRepo, (ChannelId)channelId, (String)string, (TenantId)tenantId, (Instant)instant, (Instant)instant2, (boolean)false, (int)32, null);
        Channel channel = this.channelRepo.getByIdAndDeletedFalse(channelDto.getId());
        List permissionItems = this.addPermissions(channelDto.getPermissions(), channel.getId());
        Iterable $this$forEach$iv = channelDto.getSubscriptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersonalSubscriptionKafkaDto it = (PersonalSubscriptionKafkaDto)element$iv;
            boolean bl = false;
            this.personalSubscriptionRepo.insert(it.getId(), channel.getId(), it.getProfileId(), it.getNotificationsEnabled(), it.getUserHasUnsubscribed());
        }
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    private List<PermissionItem> addPermissions(List<ChannelPermissionKafkaDto> permissionsDto, ChannelId channelId) {
        void $this$mapTo$iv$iv;
        ChannelPermissionKafkaDto it;
        Iterable it222;
        Map users;
        boolean bl;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = permissionsDto;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            ChannelPermissionKafkaDto it3 = (ChannelPermissionKafkaDto)t;
            bl = false;
            UserId key$iv$iv = it3.getGranteeId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$filterValues$iv = users = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List list = (List)entry.getValue();
            boolean bl2 = false;
            if (!(list.size() == 1)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map normalUsers = result$iv;
        Map $this$filterValues$iv2 = users;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            List it222 = (List)entry.getValue();
            bl = false;
            if (!(it222.size() > 1)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        Map usersWithMultiplePermissions = result$iv2;
        List correctPermissions = CollectionsKt.flatten((Iterable)normalUsers.values());
        List correctedPermissions = this.getLowestPermission(usersWithMultiplePermissions);
        Iterable iterable2 = CollectionsKt.plus((Collection)correctPermissions, (Iterable)correctedPermissions);
        boolean bl3 = false;
        Iterable $this$onEach_u24lambda_u2416$iv = it222 = iterable2;
        boolean bl4 = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (ChannelPermissionKafkaDto)element$iv;
            boolean bl32 = false;
            this.channelPermissionRepo.insert(it.getId(), channelId, it.getGranteeId(), it.getRole());
            this.managedSubscriptionRepo.insert(ManagedSubscriptionId.Companion.random(), channelId, ManagedSubscriptionType.NO_RECOMMENDATION, it.getGranteeId());
        }
        Iterable iterable3 = it222;
        boolean bl5 = false;
        it222 = iterable3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChannelPermissionKafkaDto)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl42 = false;
            collection.add(new PermissionItem((ItemId)channelId, it.getGranteeId(), it.getRole()));
        }
        List permissions = (List)destination$iv$iv2;
        return permissions;
    }

    /*
     * WARNING - void declaration
     */
    private List<ChannelPermissionKafkaDto> getLowestPermission(Map<UserId, ? extends List<ChannelPermissionKafkaDto>> usersWithMultiplePermissions) {
        void $this$mapTo$iv$iv;
        Map<UserId, ? extends List<ChannelPermissionKafkaDto>> $this$map$iv = usersWithMultiplePermissions;
        boolean $i$f$map = false;
        Map<UserId, ? extends List<ChannelPermissionKafkaDto>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object t;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserId userId = (UserId)entry.getKey();
            List permissionList = (List)entry.getValue();
            Iterable $this$minBy$iv = permissionList;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                ChannelPermissionKafkaDto it = (ChannelPermissionKafkaDto)minElem$iv;
                boolean bl2 = false;
                Comparable minValue$iv = (Comparable)it.getRole();
                do {
                    Object e$iv = iterator$iv.next();
                    ChannelPermissionKafkaDto it2 = (ChannelPermissionKafkaDto)e$iv;
                    $i$a$-minByOrThrow-ChannelMigrationService$getLowestPermission$1$lowest$1 = false;
                    Comparable v$iv = (Comparable)it2.getRole();
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            ChannelPermissionKafkaDto lowest = (ChannelPermissionKafkaDto)t;
            MigrationErrorRepo migrationErrorRepo = this.migrationErrorRepo;
            String string = userId.toTypedString();
            String string2 = permissionList.toString();
            MigrationErrorRepo.insert$default((MigrationErrorRepo)migrationErrorRepo, null, (String)string, (String)"User has more than one role", (String)string2, (int)1, null);
            collection.add(lowest);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(ChannelMigrationService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(ChannelMigrationService $this) {
        return $this.eventPublisher;
    }

    public static final /* synthetic */ MigratedItemRepo access$getMigratedItemRepo$p(ChannelMigrationService $this) {
        return $this.migratedItemRepo;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ChannelMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ChannelMigrationService::class.java)");
        log = logger;
    }
}

