/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka;

import de.justsoftware.news.SearchableItemId;
import de.justsoftware.news.kafka.KafkaProducerConfiguration;
import de.justsoftware.news.kafka.search.SearchIndexType;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.annotation.EnableKafka;

@Configuration
@EnableKafka
@DependsOn(value={"liquibase"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0012J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/news/kafka/KafkaProducerConfiguration;", "", "bootstrapServers", "", "(Ljava/lang/String;)V", "closingKafkaProducerConfig", "Ljava/util/Properties;", "searchIndexProducer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "Lde/justsoftware/news/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "stringProducer", "ClosingKafkaProducer", "IndexTypeSerializer", "SearchableItemIdSerializer", "news-service"})
public class KafkaProducerConfiguration {
    @NotNull
    private final String bootstrapServers;

    public KafkaProducerConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaProducer<String, String> stringProducer() {
        return (KafkaProducer)new ClosingKafkaProducer(this.closingKafkaProducerConfig(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaProducer<SearchableItemId, SearchIndexType> searchIndexProducer() {
        return (KafkaProducer)new ClosingKafkaProducer(this.closingKafkaProducerConfig(), (Serializer)new SearchableItemIdSerializer(), (Serializer)new IndexTypeSerializer());
    }

    private Properties closingKafkaProducerConfig() {
        Properties properties;
        Properties $this$closingKafkaProducerConfig_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$closingKafkaProducerConfig_u24lambda_u240.put("bootstrap.servers", this.bootstrapServers);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("acks", "all");
        $this$closingKafkaProducerConfig_u24lambda_u240.put("retries", (Object)0);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("batch.size", (Object)16384);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("linger.ms", (Object)1);
        $this$closingKafkaProducerConfig_u24lambda_u240.put("buffer.memory", (Object)0x2000000);
        return properties;
    }
}

