/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka;

import de.justsoftware.news.ItemId;
import de.justsoftware.news.kafka.KafkaMigrationProducer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/news/kafka/KafkaMigrationProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "", "(Lorg/apache/kafka/clients/producer/KafkaProducer;)V", "publishMigratedItem", "", "legacyId", "newId", "Lde/justsoftware/news/ItemId;", "Companion", "news-service"})
public class KafkaMigrationProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaProducer<String, String> producer;
    @NotNull
    private static final String TOPIC = "just.migration.item";

    public KafkaMigrationProducer(@NotNull KafkaProducer<String, String> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this.producer = producer;
    }

    public void publishMigratedItem(@NotNull String legacyId, @NotNull ItemId newId) {
        Intrinsics.checkNotNullParameter((Object)legacyId, (String)"legacyId");
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        this.producer.send(new ProducerRecord(TOPIC, (Object)legacyId, (Object)newId.toTypedString()));
    }
}

