/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.internal;

import de.justsoftware.news.kafka.toromigration.KafkaToroMigrationConsumer;
import de.justsoftware.news.kafka.toromigration.MigrationErrorRepo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/internal/MigrationHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "migrationErrorRepo", "Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;", "kafkaToroMigrationConsumer", "Lde/justsoftware/news/kafka/toromigration/KafkaToroMigrationConsumer;", "(Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;Lde/justsoftware/news/kafka/toromigration/KafkaToroMigrationConsumer;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "news-service"})
public class MigrationHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final MigrationErrorRepo migrationErrorRepo;
    @NotNull
    private final KafkaToroMigrationConsumer kafkaToroMigrationConsumer;

    public MigrationHealthIndicator(@NotNull MigrationErrorRepo migrationErrorRepo, @NotNull KafkaToroMigrationConsumer kafkaToroMigrationConsumer) {
        Intrinsics.checkNotNullParameter((Object)migrationErrorRepo, (String)"migrationErrorRepo");
        Intrinsics.checkNotNullParameter((Object)kafkaToroMigrationConsumer, (String)"kafkaToroMigrationConsumer");
        super("Migration health check failed");
        this.migrationErrorRepo = migrationErrorRepo;
        this.kafkaToroMigrationConsumer = kafkaToroMigrationConsumer;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        long count = this.migrationErrorRepo.count();
        boolean migrationDone = this.kafkaToroMigrationConsumer.getMigrationFinished();
        Status status = count > 0L || !migrationDone ? Status.DOWN : Status.UP;
        builder.status(status).withDetail("Failed item migration count", (Object)count).withDetail("Migration finished", (Object)migrationDone);
    }
}

