/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.internal;

import de.justsoftware.news.TenantId;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.maintenance.MaintenanceService;
import de.justsoftware.news.domain.migrateditem.BrokenCount;
import de.justsoftware.news.domain.migrateditem.MigrationFixService;
import de.justsoftware.news.internal.InternalRepublishService;
import de.justsoftware.news.kafka.toromigration.MigrationErrorRepo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0013J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0013J\b\u0010\u0012\u001a\u00020\u0013H\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0013J\b\u0010\u0016\u001a\u00020\u0013H\u0013J\b\u0010\u0017\u001a\u00020\u0013H\u0013J\u0012\u0010\u0018\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0013J\b\u0010\u001b\u001a\u00020\u0013H\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/news/internal/InternalController;", "", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "internalRepublishService", "Lde/justsoftware/news/internal/InternalRepublishService;", "maintenanceService", "Lde/justsoftware/news/domain/maintenance/MaintenanceService;", "migrationErrorRepo", "Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;", "migrationFixService", "Lde/justsoftware/news/domain/migrateditem/MigrationFixService;", "(Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/internal/InternalRepublishService;Lde/justsoftware/news/domain/maintenance/MaintenanceService;Lde/justsoftware/news/kafka/toromigration/MigrationErrorRepo;Lde/justsoftware/news/domain/migrateditem/MigrationFixService;)V", "countBrokenItems", "Lde/justsoftware/news/domain/migrateditem/BrokenCount;", "deleteAllMigrationErrors", "Lorg/springframework/http/ResponseEntity;", "Ljava/lang/Void;", "deleteChannelsAndPosts", "", "fixComments", "fixPosts", "fixPostsAndComments", "reIndexSearchForAllTenants", "reIndexSearchForTenant", "tenantId", "", "republishPermissions", "news-service"})
public class InternalController {
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final InternalRepublishService internalRepublishService;
    @NotNull
    private final MaintenanceService maintenanceService;
    @NotNull
    private final MigrationErrorRepo migrationErrorRepo;
    @NotNull
    private final MigrationFixService migrationFixService;

    public InternalController(@NotNull DeleteService deleteService, @NotNull InternalRepublishService internalRepublishService, @NotNull MaintenanceService maintenanceService, @NotNull MigrationErrorRepo migrationErrorRepo, @NotNull MigrationFixService migrationFixService) {
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)internalRepublishService, (String)"internalRepublishService");
        Intrinsics.checkNotNullParameter((Object)maintenanceService, (String)"maintenanceService");
        Intrinsics.checkNotNullParameter((Object)migrationErrorRepo, (String)"migrationErrorRepo");
        Intrinsics.checkNotNullParameter((Object)migrationFixService, (String)"migrationFixService");
        this.deleteService = deleteService;
        this.internalRepublishService = internalRepublishService;
        this.maintenanceService = maintenanceService;
        this.migrationErrorRepo = migrationErrorRepo;
        this.migrationFixService = migrationFixService;
    }

    @PostMapping(value={"/delete/channels-and-posts"})
    @ResponseStatus(value=HttpStatus.OK)
    private void deleteChannelsAndPosts() {
        this.deleteService.deleteChannelsAndPosts();
    }

    @PostMapping(value={"/republish/permissions"})
    @ResponseStatus(value=HttpStatus.OK)
    private void republishPermissions() {
        this.internalRepublishService.republishAll();
    }

    @PostMapping(value={"/search/reindex"})
    @ResponseStatus(value=HttpStatus.OK)
    private void reIndexSearchForAllTenants() {
        this.maintenanceService.reIndexSearchForAllTenants();
    }

    @PostMapping(value={"/search/reindex/tenants/{tenantId}"})
    @ResponseStatus(value=HttpStatus.OK)
    private void reIndexSearchForTenant(@PathVariable String tenantId) {
        this.maintenanceService.reIndexSearchForTenant(TenantId.Companion.fromString(tenantId));
    }

    @DeleteMapping(value={"/deleteAllMigrationErrors"})
    private ResponseEntity<Void> deleteAllMigrationErrors() {
        ResponseEntity responseEntity;
        try {
            this.migrationErrorRepo.deleteAll();
            ResponseEntity responseEntity2 = ResponseEntity.ok().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"{\n            migrationE\u2026ty.ok().build()\n        }");
            responseEntity = responseEntity2;
        }
        catch (Exception e) {
            ResponseEntity responseEntity3 = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"{\n            ResponseEn\u2026_ERROR).build()\n        }");
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }

    @PostMapping(value={"/migration/fix/posts"})
    private void fixPosts() {
        this.migrationFixService.fixPosts();
    }

    @PostMapping(value={"/migration/fix/comments"})
    private void fixComments() {
        this.migrationFixService.fixComments();
    }

    @PostMapping(value={"/migration/fix/posts-and-comments"})
    private void fixPostsAndComments() {
        this.migrationFixService.fixPosts();
        this.migrationFixService.fixComments();
    }

    @GetMapping(value={"/migration/fix/count-broken-items"})
    private BrokenCount countBrokenItems() {
        return this.migrationFixService.countBrokenItems();
    }
}

