/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.graphql;

import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.auth.AuthSettingsService;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionConnector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/news/graphql/ContextBuilder;", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "Lde/justsoftware/news/auth/AuthorizationContext;", "authSettingsService", "Lde/justsoftware/news/auth/AuthSettingsService;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "(Lde/justsoftware/news/auth/AuthSettingsService;Lde/justsoftware/news/connector/permission/PermissionConnector;)V", "build", "news-service"})
public class ContextBuilder
implements DgsCustomContextBuilder<AuthorizationContext> {
    @NotNull
    private final AuthSettingsService authSettingsService;
    @NotNull
    private final PermissionConnector permissionConnector;

    public ContextBuilder(@NotNull AuthSettingsService authSettingsService, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)authSettingsService, (String)"authSettingsService");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.authSettingsService = authSettingsService;
        this.permissionConnector = permissionConnector;
    }

    @NotNull
    public AuthorizationContext build() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Intrinsics.checkNotNull((Object)authentication, (String)"null cannot be cast to non-null type de.justsoftware.jwtfilter.JwtAuthenticationToken");
        JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
        return new AuthorizationContext(TenantId.Companion.fromString(String.valueOf(jwt.getCustomJwtClaims().get((Object)"tenantId"))), ProfileId.Companion.fromString(jwt.getPrincipal().toString()), this.authSettingsService, this.permissionConnector);
    }
}

