/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PersonalSubscriptionId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.UserGroupId;
import de.justsoftware.news.UserGroupMemberId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.subscription.ChannelSubscription;
import de.justsoftware.news.domain.subscription.SubscriberRepository;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscription;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionType;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscription;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.UserGroupMember;
import de.justsoftware.news.domain.user.UserGroupMemberRepo;
import de.justsoftware.news.events.ChannelPermissionChangedEvent;
import de.justsoftware.news.events.GroupMembersDeletedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 -2\u00020\u0001:\u0001-B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0017J\"\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0016J2\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0012J\u001a\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0&0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "userGroupMemberRepo", "Lde/justsoftware/news/domain/user/UserGroupMemberRepo;", "subscriberRepository", "Lde/justsoftware/news/domain/subscription/SubscriberRepository;", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/connector/permission/PermissionConnector;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/user/UserGroupMemberRepo;Lde/justsoftware/news/domain/subscription/SubscriberRepository;)V", "cleanUpPersonalSubscriptions", "", "event", "Lde/justsoftware/news/events/ChannelPermissionChangedEvent;", "Lde/justsoftware/news/events/GroupMembersDeletedEvent;", "createPersonalSubscriptions", "channelId", "Lde/justsoftware/news/ChannelId;", "userId", "Lde/justsoftware/news/UserId;", "notificationsEnabled", "", "deriveSubscription", "Lde/justsoftware/news/domain/subscription/ChannelSubscription;", "profileId", "Lde/justsoftware/news/ProfileId;", "personalSubscription", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscription;", "managedSubscriptions", "", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscription;", "findSubscription", "findSubscriptions", "", "channelIds", "getNotificationSubscribers", "getSubscribedChannelIds", "getSubscription", "getSubscriptions", "Lde/justsoftware/news/domain/user/Profile;", "Companion", "news-service"})
public class SubscriptionRepoWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final UserGroupMemberRepo userGroupMemberRepo;
    @NotNull
    private final SubscriberRepository subscriberRepository;
    private static final Logger log = LoggerFactory.getLogger(SubscriptionRepoWrapper.class);

    public SubscriptionRepoWrapper(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull PermissionConnector permissionConnector, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull UserGroupMemberRepo userGroupMemberRepo, @NotNull SubscriberRepository subscriberRepository) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepo, (String)"userGroupMemberRepo");
        Intrinsics.checkNotNullParameter((Object)subscriberRepository, (String)"subscriberRepository");
        this.channelPermissionRepo = channelPermissionRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.permissionConnector = permissionConnector;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.userGroupMemberRepo = userGroupMemberRepo;
        this.subscriberRepository = subscriberRepository;
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void cleanUpPersonalSubscriptions(@NotNull GroupMembersDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getUserGroupMemberIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            void $this$mapTo$iv$iv2;
            Map $this$map$iv2;
            UserGroupMemberId it = (UserGroupMemberId)element$iv;
            boolean bl = false;
            List subscriptions = this.personalSubscriptionRepo.getByProfileId(it.getProfileId());
            Iterable iterable = subscriptions;
            Object object = this.permissionConnector;
            boolean $i$f$map = false;
            void var12_14 = $this$map$iv2;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void subscription;
                PersonalSubscription personalSubscription = (PersonalSubscription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(subscription.getChannelId());
            }
            $this$map$iv2 = object.mayRead((Collection)((List)destination$iv$iv), (UserId)it.getProfileId());
            boolean $i$f$filter22 = false;
            $this$mapTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator<Object> iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry mayRead = element$iv$iv = (Map.Entry)iterator.next();
                boolean bl3 = false;
                if (!((Boolean)mayRead.getValue() == false)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Object channelIdsWithoutAccess = destination$iv$iv;
            Iterable $i$f$filter22 = subscriptions;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PersonalSubscription subscription = (PersonalSubscription)element$iv$iv;
                boolean bl4 = false;
                if (!channelIdsWithoutAccess.containsKey(subscription.getChannelId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PersonalSubscription subscription = (PersonalSubscription)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl5 = false;
                object.add(p0.getId());
            }
            List subscriptionsToDelete = (List)destination$iv$iv2;
            this.personalSubscriptionRepo.deleteAllById((Iterable)subscriptionsToDelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void cleanUpPersonalSubscriptions(@NotNull ChannelPermissionChangedEvent event) {
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        PersonalSubscription it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv3;
        Object element$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        Collection collection2;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List permissions = this.channelPermissionRepo.findAllByChannelId(event.getChannelId());
        Iterable $this$map$iv2 = permissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it2;
            ChannelPermission channelPermission = (ChannelPermission)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it2.getGranteeId());
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv4 = $this$filterIsInstance$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv2 instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List profileIds = (List)destination$iv$iv;
        Iterable $this$map$iv3 = permissions;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it3;
            ChannelPermission bl = (ChannelPermission)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it3.getGranteeId());
        }
        $this$map$iv3 = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstance2 = false;
        $this$mapTo$iv$iv3 = $this$filterIsInstance$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv3 instanceof UserGroupId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List it4 = (List)destination$iv$iv2;
        boolean $i$a$-let-SubscriptionRepoWrapper$cleanUpPersonalSubscriptions$profileIdsFromGroups$32 = false;
        Iterable $this$map$iv4 = this.userGroupMemberRepo.getByUserGroupIdIn((Collection)it4);
        boolean $i$f$map222 = false;
        element$iv$iv2 = $this$map$iv4;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void member;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(member.getProfileId());
        }
        List profileIdsFromGroups = (List)destination$iv$iv3;
        List profileIdsWithAccess = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)profileIds, (Iterable)profileIdsFromGroups));
        Iterable $i$a$-let-SubscriptionRepoWrapper$cleanUpPersonalSubscriptions$profileIdsFromGroups$32 = this.personalSubscriptionRepo.getByChannelIdIn((Collection)CollectionsKt.listOf((Object)event.getChannelId()));
        boolean $i$f$filter = false;
        void $i$f$map222 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            it = (PersonalSubscription)element$iv$iv4;
            boolean bl = false;
            if (!(!profileIdsWithAccess.contains(it.getProfileId()))) continue;
            destination$iv$iv4.add(element$iv$iv4);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PersonalSubscription)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl = false;
            collection2.add(it.getProfileId());
        }
        List toCleanUp = (List)destination$iv$iv4;
        if (toCleanUp.isEmpty()) {
            return;
        }
        $this$map$iv = toCleanUp;
        ChannelId channelId = event.getChannelId();
        collection2 = this.personalSubscriptionRepo;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProfileId)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        collection = (List)destination$iv$iv4;
        collection2.deleteByChannelIdAndProfileIdIn(channelId, CollectionsKt.toSet((Iterable)collection));
    }

    public void createPersonalSubscriptions(@NotNull ChannelId channelId, @NotNull UserId userId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserId userId2 = userId;
        if (userId2 instanceof ProfileId) {
            PersonalSubscription personalSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, (ProfileId)userId);
            if (personalSubscription == null) {
                PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)((ProfileId)userId), (boolean)notificationsEnabled, (boolean)false, (int)16, null);
                personalSubscription = Unit.INSTANCE;
            }
        } else if (userId2 instanceof UserGroupId) {
            log.info("Start creating personal subscriptions for all members of UserGroup: '" + userId + "'.");
            Set profileIdsOfGroup = this.userGroupMemberRepo.getProfileIdsByUserGroupId((UserGroupId)userId);
            Set channelSubscriptionsOfGroup = this.personalSubscriptionRepo.getProfileIdsByChannelIdAndProfileIdIn(channelId, (Collection)profileIdsOfGroup);
            Iterable $this$forEach$iv = profileIdsOfGroup;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProfileId profileId = (ProfileId)element$iv;
                boolean bl = false;
                if (channelSubscriptionsOfGroup.contains(profileId)) continue;
                PersonalSubscriptionRepo.insert$default((PersonalSubscriptionRepo)this.personalSubscriptionRepo, (PersonalSubscriptionId)PersonalSubscriptionId.Companion.random(), (ChannelId)channelId, (ProfileId)profileId, (boolean)notificationsEnabled, (boolean)false, (int)16, null);
            }
            log.info("Finished creating personal subscriptions for all members of UserGroup: '" + userId + "'.");
        }
    }

    public static /* synthetic */ void createPersonalSubscriptions$default(SubscriptionRepoWrapper subscriptionRepoWrapper, ChannelId channelId, UserId userId, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPersonalSubscriptions");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        subscriptionRepoWrapper.createPersonalSubscriptions(channelId, userId, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ChannelSubscription findSubscription(@NotNull ChannelId channelId, @NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdInAndUserIdIn((Collection)SetsKt.setOf((Object)channelId), (Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        PersonalSubscription personalSubscription = this.personalSubscriptionRepo.findByChannelIdAndProfileId(channelId, profileId);
        return this.deriveSubscription(channelId, profileId, personalSubscription, (Collection)managedSubscriptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChannelSubscription> findSubscriptions(@NotNull List<ChannelId> channelIds, @NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdInAndUserIdIn((Collection)channelIds, (Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        Set personalSubscriptions = this.personalSubscriptionRepo.getAllByChannelIdInAndProfileId(channelIds, profileId);
        Iterable $this$map$iv2 = channelIds;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Object v0;
            void channelId;
            Object object2;
            block4: {
                ChannelId channelId2 = (ChannelId)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = personalSubscriptions;
                for (Object object2 : iterable2) {
                    PersonalSubscription it = (PersonalSubscription)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                    v0 = object2;
                    break block4;
                }
                v0 = null;
            }
            PersonalSubscription personalSubscriptionForChannel = v0;
            Iterable $this$filter$iv = managedSubscriptions;
            boolean $i$f$filter = false;
            object2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ManagedSubscription it = (ManagedSubscription)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List managedSubscriptionsForChannel = (List)destination$iv$iv3;
            collection.add(this.deriveSubscription((ChannelId)channelId, profileId, personalSubscriptionForChannel, (Collection)managedSubscriptionsForChannel));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public ChannelSubscription getSubscription(@NotNull ChannelId channelId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ChannelSubscription channelSubscription = this.findSubscription(channelId, profileId);
        if (channelSubscription == null) {
            throw new NoSuchElementException("ProfileId: '" + profileId + "' has no subscription for ChannelId: '" + channelId + "'.");
        }
        return channelSubscription;
    }

    @NotNull
    public List<Profile> getSubscriptions(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return SubscriberRepository.getSubscribersByChannelId$default((SubscriberRepository)this.subscriberRepository, (ChannelId)channelId, null, null, null, (int)14, null);
    }

    @NotNull
    public List<ProfileId> getNotificationSubscribers(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.subscriberRepository.getNotificationSubscribers(channelId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<List<ChannelSubscription>> getSubscriptions(@NotNull List<ChannelId> channelIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Set managedSubscriptions = this.managedSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Set personalSubscriptions = this.personalSubscriptionRepo.getByChannelIdIn((Collection)channelIds);
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $this$mapTo$iv$iv2;
            Object object;
            void $this$mapTo$iv$iv3;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv4;
            Iterable $this$map$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstance$iv2;
            Collection collection;
            void $this$mapTo$iv$iv5;
            void $this$filterTo$iv$iv;
            void channelId;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv2;
            ChannelId channelId2 = (ChannelId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = personalSubscriptions;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                PersonalSubscription it = (PersonalSubscription)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List personalSubscriptionsForChannel = (List)destination$iv$iv2;
            Iterable $this$filter$iv2 = managedSubscriptions;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            element$iv$iv2 = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                ManagedSubscription it = (ManagedSubscription)element$iv$iv3;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getChannelId(), (Object)channelId)) continue;
                destination$iv$iv3.add(element$iv$iv3);
            }
            List managedSubscriptionsForChannel = (List)destination$iv$iv3;
            Iterable $this$map$iv3 = managedSubscriptionsForChannel;
            boolean $i$f$map2 = false;
            destination$iv$iv3 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv5) {
                void it;
                ManagedSubscription bl3 = (ManagedSubscription)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl4 = false;
                collection.add(it.getUserId());
            }
            $this$map$iv3 = (List)destination$iv$iv4;
            boolean $i$f$filterIsInstance22 = false;
            $this$mapTo$iv$iv5 = $this$filterIsInstance$iv2;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv4 instanceof ProfileId)) continue;
                destination$iv$iv4.add(element$iv$iv4);
            }
            List profilesFromManagedSubs = (List)destination$iv$iv4;
            Iterable $i$f$filterIsInstance22 = managedSubscriptionsForChannel;
            boolean $i$f$map3 = false;
            destination$iv$iv4 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv4) {
                void it;
                ManagedSubscription bl4 = (ManagedSubscription)item$iv$iv3;
                collection = destination$iv$iv5;
                boolean bl5 = false;
                collection.add(it.getUserId());
            }
            $this$map$iv2 = (List)destination$iv$iv5;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv4 = $this$filterIsInstance$iv;
            destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv5 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv5 instanceof UserGroupId)) continue;
                destination$iv$iv5.add(element$iv$iv5);
            }
            List groupsFromManagedSubs = (List)destination$iv$iv5;
            boolean bl6 = false;
            Iterable $this$map$iv4 = this.userGroupMemberRepo.getByUserGroupIdIn((Collection)groupsFromManagedSubs);
            boolean $i$f$map4 = false;
            Iterable element$iv$iv4 = $this$map$iv4;
            Object destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                void it;
                object = (UserGroupMember)item$iv$iv4;
                Collection collection3 = destination$iv$iv6;
                boolean bl7 = false;
                collection3.add(it.getProfileId());
            }
            List profilesFromGroupsFromManagedSubs = (List)destination$iv$iv6;
            Iterable $this$map$iv5 = personalSubscriptions;
            boolean $i$f$map5 = false;
            $this$map$iv4 = $this$map$iv5;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo222 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv2) {
                void it;
                PersonalSubscription bl5 = (PersonalSubscription)item$iv$iv5;
                collection = destination$iv$iv7;
                boolean bl8 = false;
                collection.add(it.getProfileId());
            }
            List profilesFromPersonalSubs = (List)destination$iv$iv7;
            List subscribers = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)profilesFromManagedSubs, (Iterable)profilesFromGroupsFromManagedSubs), (Iterable)profilesFromPersonalSubs));
            Set groupsForAllSubscribers = this.userGroupMemberRepo.getByProfileIdIn((Collection)subscribers);
            $this$mapTo$iv$iv2 = subscribers;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapTo222 = $this$mapNotNull$iv;
            destination$iv$iv6 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                ChannelSubscription it$iv$iv;
                Object v0;
                List managedSubscriptionsForUser;
                ProfileId subscriber;
                block14: {
                    void $this$filterTo$iv$iv3;
                    Object item$iv$iv62;
                    void $this$mapTo$iv$iv6;
                    void $this$map$iv6;
                    UserGroupMember userGroupMember;
                    void $this$filterTo$iv$iv4;
                    Iterable $this$filter$iv3;
                    Object element$iv$iv$iv;
                    Object element$iv$iv6 = element$iv$iv$iv = object.next();
                    boolean bl9 = false;
                    subscriber = (ProfileId)element$iv$iv6;
                    boolean bl10 = false;
                    Iterable iterable3 = groupsForAllSubscribers;
                    boolean $i$f$filter3 = false;
                    void var36_69 = $this$filter$iv3;
                    Iterable destination$iv$iv8 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv7 : $this$filterTo$iv$iv4) {
                        userGroupMember = (UserGroupMember)element$iv$iv7;
                        boolean bl11 = false;
                        if (!Intrinsics.areEqual((Object)userGroupMember.getProfileId(), (Object)subscriber)) continue;
                        destination$iv$iv8.add(element$iv$iv7);
                    }
                    $this$filter$iv3 = (List)destination$iv$iv8;
                    boolean $i$f$map6 = false;
                    $this$filterTo$iv$iv4 = $this$map$iv6;
                    destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    boolean $i$f$mapTo5 = false;
                    for (Object item$iv$iv62 : $this$mapTo$iv$iv6) {
                        userGroupMember = (UserGroupMember)item$iv$iv62;
                        Collection collection4 = destination$iv$iv8;
                        boolean bl12 = false;
                        collection4.add(userGroupMember.getUserGroupId());
                    }
                    List groupsForSubscriber = (List)destination$iv$iv8;
                    Iterable $this$filter$iv4 = managedSubscriptionsForChannel;
                    boolean $i$f$filter4 = false;
                    destination$iv$iv8 = $this$filter$iv4;
                    Collection destination$iv$iv9 = new ArrayList();
                    boolean $i$f$filterTo4 = false;
                    item$iv$iv62 = $this$filterTo$iv$iv3.iterator();
                    while (item$iv$iv62.hasNext()) {
                        Object element$iv$iv8 = item$iv$iv62.next();
                        ManagedSubscription it = (ManagedSubscription)element$iv$iv8;
                        boolean bl13 = false;
                        if (!(Intrinsics.areEqual((Object)it.getUserId(), (Object)subscriber) || CollectionsKt.contains((Iterable)groupsForSubscriber, (Object)it.getUserId()))) continue;
                        destination$iv$iv9.add(element$iv$iv8);
                    }
                    managedSubscriptionsForUser = (List)destination$iv$iv9;
                    Iterable iterable4 = personalSubscriptionsForChannel;
                    for (Object t : iterable4) {
                        PersonalSubscription it = (PersonalSubscription)t;
                        boolean bl14 = false;
                        if (!Intrinsics.areEqual((Object)it.getProfileId(), (Object)subscriber)) continue;
                        v0 = t;
                        break block14;
                    }
                    v0 = null;
                }
                PersonalSubscription personalSubscriptionForUser = v0;
                if (this.deriveSubscription((ChannelId)channelId, subscriber, personalSubscriptionForUser, (Collection)managedSubscriptionsForUser) == null) continue;
                boolean bl15 = false;
                destination$iv$iv6.add(it$iv$iv);
            }
            collection2.add((List)destination$iv$iv6);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChannelId> getSubscribedChannelIds(@NotNull ProfileId profileId) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable $this$map$iv2 = this.userGroupMemberRepo.getByProfileId(profileId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getUserGroupId());
        }
        List userGroupIds = (List)destination$iv$iv;
        Set managedSubscriptions = this.managedSubscriptionRepo.getByUserIdIn((Collection)CollectionsKt.plus((Collection)userGroupIds, (Object)profileId));
        List personalSubscriptions = this.personalSubscriptionRepo.getByProfileId(profileId);
        Iterable $this$filter$iv2 = managedSubscriptions;
        boolean $i$f$filter22 = false;
        Iterable iterable2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ManagedSubscription it = (ManagedSubscription)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == ManagedSubscriptionType.MANDATORY)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List mandatory = (List)destination$iv$iv2;
        Iterable $i$f$filter22 = managedSubscriptions;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == ManagedSubscriptionType.RECOMMENDED)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PersonalSubscription personalSubscriptionForChannel;
            Object v0;
            block9: {
                ManagedSubscription managed = (ManagedSubscription)element$iv$iv;
                boolean bl = false;
                Iterable iterable3 = personalSubscriptions;
                for (Object t : iterable3) {
                    PersonalSubscription it = (PersonalSubscription)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)managed.getChannelId(), (Object)it.getChannelId())) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            if (!((personalSubscriptionForChannel = (PersonalSubscription)v0) == null || !personalSubscriptionForChannel.getUserHasUnsubscribed())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List recommended = (List)destination$iv$iv3;
        $this$filter$iv = personalSubscriptions;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PersonalSubscription it = (PersonalSubscription)element$iv$iv;
            boolean bl = false;
            if (!(!it.getUserHasUnsubscribed())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PersonalSubscription it = (PersonalSubscription)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add(it.getChannelId());
        }
        $this$map$iv = mandatory;
        collection2 = (List)destination$iv$iv3;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        $this$map$iv = recommended;
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3));
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ManagedSubscription it = (ManagedSubscription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3)));
    }

    private ChannelSubscription deriveSubscription(ChannelId channelId, ProfileId profileId, PersonalSubscription personalSubscription, Collection<ManagedSubscription> managedSubscriptions) {
        boolean recommended;
        boolean mandatory;
        block12: {
            boolean bl;
            boolean bl2;
            block11: {
                if (personalSubscription == null && managedSubscriptions.isEmpty()) {
                    return null;
                }
                Iterable $this$any$iv = managedSubscriptions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ManagedSubscription it = (ManagedSubscription)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() == ManagedSubscriptionType.MANDATORY)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            mandatory = bl2;
            Iterable $this$any$iv = managedSubscriptions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ManagedSubscription it = (ManagedSubscription)element$iv;
                    boolean bl4 = false;
                    if (!(it.getType() == ManagedSubscriptionType.RECOMMENDED)) continue;
                    bl = true;
                    break block12;
                }
                bl = recommended = false;
            }
        }
        if (mandatory) {
            return new ChannelSubscription(channelId, profileId, true, true);
        }
        if (recommended) {
            PersonalSubscription personalSubscription2 = personalSubscription;
            boolean bl = personalSubscription2 != null ? personalSubscription2.getUserHasUnsubscribed() : false;
            if (bl) {
                return null;
            }
            PersonalSubscription personalSubscription3 = personalSubscription;
            return new ChannelSubscription(channelId, profileId, false, personalSubscription3 != null ? personalSubscription3.getNotificationsEnabled() : true);
        }
        if (personalSubscription == null || personalSubscription.getUserHasUnsubscribed()) {
            return null;
        }
        return new ChannelSubscription(channelId, profileId, false, personalSubscription.getNotificationsEnabled());
    }
}

