/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.domain.subscription.SubscriberRepository;
import de.justsoftware.news.domain.user.Profile;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0012J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J?\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lde/justsoftware/news/domain/subscription/SubscriberRepository;", "", "jdbcTemplate", "Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "dbDialect", "Lorg/springframework/data/relational/core/dialect/Dialect;", "(Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;Lorg/springframework/data/relational/core/dialect/Dialect;)V", "getDbDialect", "()Lorg/springframework/data/relational/core/dialect/Dialect;", "getJdbcTemplate", "()Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "profileIdRowMapper", "Lde/justsoftware/news/domain/subscription/SubscriberRepository$ProfileIdRowMapper;", "profileRowMapper", "Lde/justsoftware/news/domain/subscription/SubscriberRepository$ProfileRowMapper;", "getProfileRowMapper", "()Lde/justsoftware/news/domain/subscription/SubscriberRepository$ProfileRowMapper;", "countSubscribersByChannel", "", "channelId", "Lde/justsoftware/news/ChannelId;", "query", "", "(Lde/justsoftware/news/ChannelId;Ljava/lang/String;)Ljava/lang/Integer;", "getLikeQuery", "getNotificationSubscribers", "", "Lde/justsoftware/news/ProfileId;", "getSubscribersByChannelId", "Lde/justsoftware/news/domain/user/Profile;", "limit", "offset", "(Lde/justsoftware/news/ChannelId;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Ljava/util/List;", "Companion", "ProfileIdRowMapper", "ProfileRowMapper", "news-service"})
public class SubscriberRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedParameterJdbcTemplate jdbcTemplate;
    @NotNull
    private final Dialect dbDialect;
    @NotNull
    private final ProfileRowMapper profileRowMapper;
    @NotNull
    private final ProfileIdRowMapper profileIdRowMapper;
    @NotNull
    private static final String getSubscriberIdsStatement = "\n            -- active personal_subscriptions\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='0'\n            union \n            -- active managed recommended subscriptions for profiles\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ms.user_id)\n            union\n            -- active managed recommended subcriptions for groups\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ugm.profile_id)\n            union\n            -- am ende alle managed_subscriptions mit forced dazu laden\n            -- forced personal subscriptions\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        ";
    @NotNull
    public static final String getSubscribersStatement = "\n            select * from profile p where p.status ='ACTIVE' and p.id in (\n                \n            -- active personal_subscriptions\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='0'\n            union \n            -- active managed recommended subscriptions for profiles\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ms.user_id)\n            union\n            -- active managed recommended subcriptions for groups\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ugm.profile_id)\n            union\n            -- am ende alle managed_subscriptions mit forced dazu laden\n            -- forced personal subscriptions\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            )\n            ";
    @NotNull
    public static final String getNotificationSubscribersStatement = "\n            select p.id from profile p where p.status ='ACTIVE' and p.id in (\n                \n            -- active personal_subscriptions\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='0'\n            union \n            -- active managed recommended subscriptions for profiles\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ms.user_id)\n            union\n            -- active managed recommended subcriptions for groups\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ugm.profile_id)\n            union\n            -- am ende alle managed_subscriptions mit forced dazu laden\n            -- forced personal subscriptions\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            ) and p.id not in (select profile_id from personal_subscription ps where ps.notifications_enabled = '0' and p.id = ps.profile_id and ps.channel_id = :channelId)\n            ";

    public SubscriberRepository(@NotNull NamedParameterJdbcTemplate jdbcTemplate, @NotNull Dialect dbDialect) {
        Intrinsics.checkNotNullParameter((Object)jdbcTemplate, (String)"jdbcTemplate");
        Intrinsics.checkNotNullParameter((Object)dbDialect, (String)"dbDialect");
        this.jdbcTemplate = jdbcTemplate;
        this.dbDialect = dbDialect;
        this.profileRowMapper = new ProfileRowMapper();
        this.profileIdRowMapper = new ProfileIdRowMapper();
    }

    @NotNull
    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @NotNull
    public Dialect getDbDialect() {
        return this.dbDialect;
    }

    @NotNull
    public ProfileRowMapper getProfileRowMapper() {
        return this.profileRowMapper;
    }

    @NotNull
    public List<Profile> getSubscribersByChannelId(@NotNull ChannelId channelId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String query) {
        String string;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String string2 = limit != null ? (offset != null ? this.getDbDialect().limit().getLimitOffset((long)limit.intValue(), (long)offset.intValue()) : this.getDbDialect().limit().getLimit((long)limit.intValue())) : "";
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (limit != null) {\n   \u2026  }\n            } else \"\"");
        String limitString = string2;
        String likeQuery = this.getLikeQuery(query);
        String orderByString = " ORDER by p.last_name ASC ";
        String finalStatement = getSubscribersStatement + likeQuery + orderByString + limitString;
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString());
        String string3 = query;
        if (string3 != null) {
            String string4 = string3.toUpperCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        } else {
            string = null;
        }
        pairArray[1] = TuplesKt.to((Object)"query", (Object)(string + "%"));
        Map paramsMap = MapsKt.mapOf((Pair[])pairArray);
        List list = this.getJdbcTemplate().query(finalStatement, paramsMap, (RowMapper)this.getProfileRowMapper());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jdbcTemplate.query(final\u2026amsMap, profileRowMapper)");
        return list;
    }

    public static /* synthetic */ List getSubscribersByChannelId$default(SubscriberRepository subscriberRepository, ChannelId channelId, Integer n, Integer n2, String string, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSubscribersByChannelId");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            string = null;
        }
        return subscriberRepository.getSubscribersByChannelId(channelId, n, n2, string);
    }

    @NotNull
    public List<ProfileId> getNotificationSubscribers(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        List list = this.getJdbcTemplate().query(getNotificationSubscribersStatement, MapsKt.mapOf((Pair)TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString())), (RowMapper)this.profileIdRowMapper);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jdbcTemplate.query(\n    \u2026fileIdRowMapper\n        )");
        return list;
    }

    private String getLikeQuery(String query) {
        CharSequence charSequence = query;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? " AND (UPPER(p.last_name) LIKE :query OR UPPER(p.first_name) LIKE :query OR UPPER(p.prefix) LIKE :query OR UPPER(p.suffix) LIKE :query) " : " ";
    }

    @Nullable
    public Integer countSubscribersByChannel(@NotNull ChannelId channelId, @Nullable String query) {
        String string;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String likeQuery = this.getLikeQuery(query);
        String statement = StringsKt.trimIndent((String)("\n            SELECT count(1) FROM profile p WHERE p.status ='ACTIVE' and p.id IN (\n                \n            -- active personal_subscriptions\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='0'\n            union \n            -- active managed recommended subscriptions for profiles\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ms.user_id)\n            union\n            -- active managed recommended subcriptions for groups\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id  \n            from personal_subscription ps \n            where ps.channel_id = :channelId and ps.user_has_unsubscribed ='1' and ps.profile_id=ugm.profile_id)\n            union\n            -- am ende alle managed_subscriptions mit forced dazu laden\n            -- forced personal subscriptions\n            select ms.user_id  \n            from managed_subscription ms \n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n            -- forced group subscriptions\n            select ugm.profile_id \n            from user_group_member ugm \n            where ugm.user_group_id  in (\n                select ms.user_id \n                from managed_subscription ms \n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            ) " + likeQuery + "\n        "));
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString());
        String string2 = query;
        if (string2 != null) {
            String string3 = string2.toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        } else {
            string = null;
        }
        pairArray[1] = TuplesKt.to((Object)"query", (Object)(string + "%"));
        Map paramsMap = MapsKt.mapOf((Pair[])pairArray);
        return (Integer)this.getJdbcTemplate().queryForObject(statement, paramsMap, Integer.TYPE);
    }
}

