/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.settings;

import de.justsoftware.news.ItemId;
import de.justsoftware.news.TenantId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.settings.Settings;
import de.justsoftware.news.domain.settings.SettingsRepo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/domain/settings/SettingsService;", "", "settingsRepo", "Lde/justsoftware/news/domain/settings/SettingsRepo;", "(Lde/justsoftware/news/domain/settings/SettingsRepo;)V", "editSettings", "Lde/justsoftware/news/domain/settings/Settings;", "allMayReadSubscriptionProfiles", "", "allowAdditionalInfoInMailNotification", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/settings/Settings;", "getSettings", "news-service"})
public class SettingsService {
    @NotNull
    private final SettingsRepo settingsRepo;

    public SettingsService(@NotNull SettingsRepo settingsRepo) {
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        this.settingsRepo = settingsRepo;
    }

    @NotNull
    public Settings getSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        authContext.checkManage((ItemId)tenantId);
        return this.settingsRepo.getByTenantId(tenantId);
    }

    @NotNull
    public Settings editSettings(@Nullable Boolean allMayReadSubscriptionProfiles, @Nullable Boolean allowAdditionalInfoInMailNotification, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        authContext.checkManage((ItemId)tenantId);
        Settings origin = this.settingsRepo.getByTenantId(tenantId);
        Boolean bl = allMayReadSubscriptionProfiles;
        Boolean bl2 = allowAdditionalInfoInMailNotification;
        Settings update = Settings.copy$default((Settings)origin, null, (boolean)(bl != null ? bl.booleanValue() : origin.getAllMayReadSubscriptionProfiles()), (boolean)(bl2 != null ? bl2.booleanValue() : origin.getAllowAdditionalInfoInMailNotification()), (int)1, null);
        Object object = this.settingsRepo.save((Object)update);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"settingsRepo.save(update)");
        return (Settings)object;
    }
}

