/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.reaction;

import de.justsoftware.news.CommentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.ReactionId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.reaction.ReactionService;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0017J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0017J*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u0010 \u001a\u00020!2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0017J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/domain/reaction/ReactionService;", "", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "(Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;)V", "addLike", "Lde/justsoftware/news/domain/reaction/Reaction;", "itemId", "Lde/justsoftware/news/ItemId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "addReaction", "emoji", "", "countLikesByItemIds", "", "", "itemIds", "", "deleteLike", "deleteReaction", "reactionId", "Lde/justsoftware/news/ReactionId;", "findAllByItemId", "", "findAllLikesByItemIds", "getLikesForProfileByItemIds", "", "profileId", "Lde/justsoftware/news/ProfileId;", "likes", "", "Companion", "news-service"})
public class ReactionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    public static final String LIKE_EMOJI = ":thumbsup:";

    public ReactionService(@NotNull PostRepo postRepo, @NotNull ReactionRepo reactionRepo, @NotNull PostCommentRepo postCommentRepo) {
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        this.postRepo = postRepo;
        this.reactionRepo = reactionRepo;
        this.postCommentRepo = postCommentRepo;
    }

    public void likes(@NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        PostId postId;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ItemId itemId2 = itemId;
        if (itemId2 instanceof PostId) {
            postId = (PostId)itemId;
        } else if (itemId2 instanceof CommentId) {
            postId = this.postCommentRepo.getById((CommentId)itemId).getPostId();
        } else {
            throw new IllegalArgumentException("Only comments and posts are valid likable items. Got: " + itemId + ".");
        }
        PostId idToCheck = postId;
        authContext.checkRead((ItemId)idToCheck);
    }

    @NotNull
    public Reaction addLike(@NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.addReaction(LIKE_EMOJI, itemId, authContext);
    }

    @NotNull
    public Reaction addReaction(@NotNull String emoji, @NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostId itemToAuthenticate = itemId instanceof CommentId ? this.postCommentRepo.getById((CommentId)itemId).getPostId() : (PostId)itemId;
        Post post = this.postRepo.getByIdAndDeletedFalse(itemToAuthenticate);
        authContext.checkPostAction(post.getId(), PostAction.REACT);
        Reaction original = this.reactionRepo.findByItemIdAndEmojiAndProfileId(itemId, emoji, authContext.getUser());
        if (original != null) {
            return original;
        }
        ReactionId reactionId = ReactionId.Companion.random();
        this.reactionRepo.insert(reactionId, emoji, itemId, authContext.getUser());
        return this.reactionRepo.getById(reactionId);
    }

    @Nullable
    public Reaction deleteLike(@NotNull ItemId itemId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Reaction like = this.reactionRepo.findByItemIdAndEmojiAndProfileId(itemId, LIKE_EMOJI, authContext.getUser());
        if (like != null) {
            authContext.checkUserEqual(like.getProfileId());
            this.reactionRepo.deleteById((Object)like.getId());
        }
        return like;
    }

    @Nullable
    public Reaction deleteReaction(@NotNull ReactionId reactionId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)reactionId, (String)"reactionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.reactionRepo.findById((Object)reactionId).map(arg_0 -> ReactionService.deleteReaction$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).orElse(null);
    }

    @Unauthorized
    @NotNull
    public List<Reaction> findAllByItemId(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.reactionRepo.findAllByItemId(itemId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<Reaction> findAllLikesByItemIds(@NotNull Collection<? extends ItemId> itemIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$filter$iv = this.reactionRepo.findAllByItemIdIn(CollectionsKt.toSet((Iterable)itemIds));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Reaction it = (Reaction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEmoji(), (Object)LIKE_EMOJI)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<ItemId, Integer> countLikesByItemIds(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Map likeCounts = this.reactionRepo.countLikesByItemIdsIn(CollectionsKt.toSet((Iterable)itemIds));
        Iterable $this$associateWith$iv = itemIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = ((Number)likeCounts.getOrDefault(it, 0)).intValue();
            map.put(t, n);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<ItemId, Boolean> getLikesForProfileByItemIds(@NotNull ProfileId profileId, @NotNull Collection<? extends ItemId> itemIds) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable iterable = this.reactionRepo.findAllLikesForItemsAndProfile(CollectionsKt.toSet((Iterable)itemIds), profileId);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Reaction reaction = (Reaction)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getItemId(), element$iv$iv2);
        }
        Map likedItems = destination$iv$iv;
        Iterable $this$associateWith$iv = itemIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Object element$iv$iv2;
            element$iv$iv2 = (ItemId)element$iv$iv;
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Boolean bl2 = likedItems.containsKey(it);
            map.put(t, bl2);
        }
        return result$iv;
    }

    private static final Reaction deleteReaction$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Reaction)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ReactionRepo access$getReactionRepo$p(ReactionService $this) {
        return $this.reactionRepo;
    }
}

