/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PollId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.ChannelDataLoader;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.post.AllowedPostActionsDataLoader;
import de.justsoftware.news.domain.post.AttachmentDataLoader;
import de.justsoftware.news.domain.post.CommentCountByPostIds;
import de.justsoftware.news.domain.post.CommentDataLoader;
import de.justsoftware.news.domain.post.PollDataLoader;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostDataFetcherKt;
import de.justsoftware.news.domain.post.PostIdWithSortOrder;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.post.model.PostTranslation;
import de.justsoftware.news.domain.post.model.TranslationLanguage;
import de.justsoftware.news.domain.reaction.ReactionDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.AddPollInput;
import de.justsoftware.news.graphql.generated.types.AddPostInput;
import de.justsoftware.news.graphql.generated.types.Attachment;
import de.justsoftware.news.graphql.generated.types.AttachmentInput;
import de.justsoftware.news.graphql.generated.types.Channel;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.EditPostInput;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.graphql.generated.types.Reaction;
import de.justsoftware.news.util.Sort;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017JH\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020 2\b\b\u0001\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020#H\u0017J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010*\u001a\u00020+2\b\b\u0001\u0010,\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010-\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J$\u0010/\u001a\u00020\f2\b\b\u0001\u0010,\u001a\u00020+2\b\b\u0001\u0010$\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J4\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020 2\b\b\u0001\u0010$\u001a\u00020#H\u0017J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u00107\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010,\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J8\u0010:\u001a\u00020;2\b\b\u0001\u0010<\u001a\u00020+2\b\b\u0001\u0010=\u001a\u00020>2\b\b\u0001\u0010?\u001a\u00020>2\b\b\u0001\u0010@\u001a\u00020A2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006B"}, d2={"Lde/justsoftware/news/domain/post/PostDataFetcher;", "", "postService", "Lde/justsoftware/news/domain/post/PostService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "(Lde/justsoftware/news/domain/post/PostService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "getDeleteService", "()Lde/justsoftware/news/domain/delete/DeleteService;", "getPostService", "()Lde/justsoftware/news/domain/post/PostService;", "addPost", "Lde/justsoftware/news/graphql/generated/types/Post;", "input", "Lde/justsoftware/news/graphql/generated/types/AddPostInput;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "allowedActions", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/domain/post/model/PostAction;", "attachments", "Lde/justsoftware/news/graphql/generated/types/Attachment;", "author", "Lde/justsoftware/news/graphql/generated/types/Profile;", "channel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "channelPosts", "", "channelId", "Lde/justsoftware/news/ChannelId;", "offset", "", "limit", "scheduled", "", "pinned", "commentCount", "comments", "Lde/justsoftware/news/graphql/generated/types/Comment;", "sort", "Lde/justsoftware/news/util/Sort;", "deletePost", "Lde/justsoftware/news/PostId;", "id", "editPost", "Lde/justsoftware/news/graphql/generated/types/EditPostInput;", "editPostPinned", "editor", "feed", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "poll", "Lde/justsoftware/news/graphql/generated/types/Poll;", "post", "reactions", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "translatePost", "Lde/justsoftware/news/domain/post/model/PostTranslation;", "postId", "title", "", "text", "targetLanguage", "Lde/justsoftware/news/domain/post/model/TranslationLanguage;", "news-service"})
public class PostDataFetcher {
    @NotNull
    private final PostService postService;
    @NotNull
    private final DeleteService deleteService;

    public PostDataFetcher(@NotNull PostService postService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.postService = postService;
        this.deleteService = deleteService;
    }

    @NotNull
    public PostService getPostService() {
        return this.postService;
    }

    @NotNull
    public DeleteService getDeleteService() {
        return this.deleteService;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="channelPosts")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Post> channelPosts(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull ChannelId channelId, @InputArgument int offset, @InputArgument int limit, @InputArgument boolean scheduled, @InputArgument boolean pinned) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Iterable iterable = this.getPostService().getChannelPosts(channelId, offset, limit, scheduled, pinned, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PostDataFetcherKt.toGql((Post)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="feed")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Post> feed(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument int offset, @InputArgument int limit, @InputArgument boolean pinned) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable iterable = this.getPostService().getFeed(offset, limit, pinned, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PostDataFetcherKt.toGql((Post)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsQuery(field="post")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Post post(@InputArgument @NotNull PostId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Post post = this.getPostService().findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return post != null ? PostDataFetcherKt.toGql((Post)post) : null;
    }

    /*
     * WARNING - void declaration
     */
    @DgsMutation(field="addPost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post addPost(@InputArgument @NotNull AddPostInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Instant instant;
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = PostId.Companion.random();
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)postId) : null;
        PostService postService = this.getPostService();
        ChannelId channelId = input.getChannelId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        PostId postId2 = postId;
        AttachmentInput attachmentInput = input.getAttachments();
        Boolean bl = input.getPinned();
        Poll poll2 = poll;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll3 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll3 != null ? poll3.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        Integer n = input.getPublishDate();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            List list2 = list;
            Poll poll4 = poll2;
            Boolean bl2 = bl;
            AttachmentInput attachmentInput2 = attachmentInput;
            PostId postId3 = postId2;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            ChannelId channelId2 = channelId;
            PostService postService2 = postService;
            boolean bl3 = false;
            Instant instant2 = Instant.ofEpochSecond((long)it);
            postService = postService2;
            channelId = channelId2;
            string = string6;
            string2 = string5;
            string3 = string4;
            postId2 = postId3;
            attachmentInput = attachmentInput2;
            bl = bl2;
            poll2 = poll4;
            list = list2;
            instant = instant2;
        } else {
            instant = null;
        }
        return PostDataFetcherKt.toGql((Post)postService.create(channelId, string, string2, string3, postId2, attachmentInput, bl, poll2, list, instant, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    /*
     * WARNING - void declaration
     */
    @DgsMutation(field="editPost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post editPost(@InputArgument @NotNull EditPostInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Instant instant;
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)input.getId()) : null;
        PostService postService = this.getPostService();
        PostId postId = input.getId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        AttachmentInput attachmentInput = input.getAttachments();
        Boolean bl = input.getPinned();
        Poll poll2 = poll;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll3 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll3 != null ? poll3.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        Boolean bl2 = input.getDeletePoll();
        Integer n = input.getPublishDate();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            Boolean bl3 = bl2;
            List list2 = list;
            Poll poll4 = poll2;
            Boolean bl4 = bl;
            AttachmentInput attachmentInput2 = attachmentInput;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            PostId postId2 = postId;
            PostService postService2 = postService;
            boolean bl5 = false;
            Instant instant2 = Instant.ofEpochSecond((long)it);
            postService = postService2;
            postId = postId2;
            string = string6;
            string2 = string5;
            string3 = string4;
            attachmentInput = attachmentInput2;
            bl = bl4;
            poll2 = poll4;
            list = list2;
            bl2 = bl3;
            instant = instant2;
        } else {
            instant = null;
        }
        return PostDataFetcherKt.toGql((Post)postService.edit(postId, string, string2, string3, attachmentInput, bl, poll2, list, bl2, instant, input.getPublished(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="editPostPinned")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post editPostPinned(@InputArgument @NotNull PostId id, @InputArgument boolean pinned, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return PostDataFetcherKt.toGql((Post)this.getPostService().editPostPinned(id, pinned, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deletePost")
    @NotNull
    public PostId deletePost(@InputArgument @NotNull PostId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.getDeleteService().markPostForDeletion(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="Post", field="attachments")
    @NotNull
    public CompletableFuture<Attachment> attachments(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(AttachmentDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(postId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="author")
    @NotNull
    public CompletableFuture<Profile> author(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId authorId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getAuthorId();
        CompletableFuture completableFuture = dataLoader.load((Object)authorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(authorId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="editor")
    @NotNull
    public CompletableFuture<Profile> editor(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ProfileId profileId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getEditorId();
        if (profileId == null) {
            CompletableFuture<Profile> completableFuture = CompletableFuture.supplyAsync(PostDataFetcher::editor$lambda$4);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync { null }");
            return completableFuture;
        }
        ProfileId editorId = profileId;
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)editorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(editorId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="channel")
    @NotNull
    public CompletableFuture<Channel> channel(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ChannelDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getChannelId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="comments")
    @NotNull
    public CompletableFuture<Comment> comments(@NotNull Sort sort, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)new PostIdWithSortOrder(postId, sort));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(PostIdWithSortOrder(postId, sort))");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="poll")
    @NotNull
    public CompletableFuture<de.justsoftware.news.graphql.generated.types.Poll> poll(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(postId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="reactions")
    @NotNull
    public CompletableFuture<Reaction> reactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ReactionDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(postId)");
        return completableFuture;
    }

    @DgsMutation(field="translatePost")
    @NotNull
    public PostTranslation translatePost(@InputArgument @NotNull PostId postId, @InputArgument @NotNull String title, @InputArgument @NotNull String text, @InputArgument @NotNull TranslationLanguage targetLanguage, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.getPostService().translatePost(postId, title, text, targetLanguage, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="Post", field="commentCount")
    @NotNull
    public CompletableFuture<Integer> commentCount(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentCountByPostIds.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(postId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<PostAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(AllowedPostActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(postId)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)((de.justsoftware.news.graphql.generated.types.Post)dfe.getSource()).getId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"newResult<Likes>()\n     \u2026.id)\n            .build()");
        return dataFetcherResult;
    }

    private static final Profile editor$lambda$4() {
        return null;
    }
}

