/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import de.justsoftware.news.ItemId;
import de.justsoftware.news.PollAnswerId;
import de.justsoftware.news.PollId;
import de.justsoftware.news.PollVoteId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollPrivacy;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollService$findAnswersByPollId$;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J2\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000fH\u0017J&\u0010 \u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/news/domain/poll/PollService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "findAnswersByPollId", "", "Lde/justsoftware/news/domain/poll/PollAnswer;", "pollId", "Lde/justsoftware/news/PollId;", "findPollByPostId", "Lde/justsoftware/news/domain/poll/Poll;", "postId", "Lde/justsoftware/news/PostId;", "findVotesByAnswerId", "Lde/justsoftware/news/domain/poll/PollVote;", "pollAnswerId", "Lde/justsoftware/news/PollAnswerId;", "findVotesToAnswerIds", "", "", "pollAnswerIds", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "getById", "id", "vote", "yesAnswers", "voteCountByAnswerId", "", "news-service"})
public class PollService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final PostRepo postRepo;

    public PollService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.postRepo = postRepo;
    }

    @Transactional
    @NotNull
    public Poll vote(@NotNull PollId pollId, @NotNull List<PollAnswerId> yesAnswers, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll = this.pollRepo.getById(pollId);
        Post post = this.postRepo.getByIdAndDeletedFalse(poll.getPostId());
        authContext.checkPostAction(post.getId(), PostAction.VOTE);
        this.pollVoteRepo.deleteAllByPollIdAndProfileId(poll.getId(), authContext.getUser());
        Iterable $this$forEach$iv = yesAnswers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PollAnswerId it = (PollAnswerId)element$iv;
            boolean bl = false;
            this.pollVoteRepo.insert(PollVoteId.Companion.random(), poll.getId(), it, authContext.getUser());
        }
        return poll;
    }

    @Unauthorized
    @NotNull
    public Poll getById(@NotNull PollId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.pollRepo.getById(id);
    }

    @Unauthorized
    @Nullable
    public Poll findPollByPostId(@NotNull PostId postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.pollRepo.findByPostId(postId);
    }

    @Unauthorized
    @NotNull
    public List<PollAnswer> findAnswersByPollId(@NotNull PollId pollId) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Iterable $this$sortedBy$iv = this.pollAnswerRepo.findAllByPollId(pollId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAnswersByPollId$$inlined$sortedBy$1()));
    }

    @Unauthorized
    @NotNull
    public List<PollVote> findVotesByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.findByAnswerId(pollAnswerId);
    }

    @Unauthorized
    public int voteCountByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.countByAnswerId(pollAnswerId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PollAnswerId, Set<PollVote>> findVotesToAnswerIds(@NotNull Set<PollAnswerId> pollAnswerIds, @NotNull AuthorizationContext authContext) {
        void $this$associateByTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable answersForBatch;
        Intrinsics.checkNotNullParameter(pollAnswerIds, (String)"pollAnswerIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set votesForBatch = this.pollVoteRepo.findByAnswerIdIn(pollAnswerIds);
        Iterable iterable = this.pollAnswerRepo.findAllById((Iterable)pollAnswerIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"pollAnswerRepo.findAllById(pollAnswerIds)");
        Iterable iterable2 = answersForBatch = iterable;
        Object object = this.pollRepo;
        boolean $i$f$map22 = false;
        void var9_10 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPollId());
        }
        Iterable iterable3 = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"pollRepo.findAllById(ans\u2026rBatch.map { it.pollId })");
        Set pollsForBatch = CollectionsKt.toSet((Iterable)iterable3);
        Iterable $i$f$map22 = pollsForBatch;
        object = this.postRepo;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Poll bl = (Poll)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPostId());
        }
        Iterable iterable4 = object.findAllById((Iterable)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"postRepo.findAllById(pol\u2026rBatch.map { it.postId })");
        Iterable $this$associateBy$iv = iterable4;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            Post it = (Post)element$iv$iv2;
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.put(it.getId(), element$iv$iv2);
        }
        Object postsForBatch = destination$iv$iv2;
        Iterable $this$associateWith$iv = pollAnswerIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Set set2;
            Poll poll;
            Object object2;
            Object object3;
            void pollAnswerId;
            Object object42;
            block14: {
                Object v3;
                Object it;
                block13: {
                    Object element$iv$iv2;
                    element$iv$iv2 = (PollAnswerId)element$iv$iv;
                    collection = element$iv$iv;
                    object = result$iv;
                    boolean bl = false;
                    Iterable bl3 = answersForBatch;
                    for (Object object42 : bl3) {
                        it = (PollAnswer)object42;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)pollAnswerId)) continue;
                        v3 = object42;
                        break block13;
                    }
                    v3 = null;
                }
                PollAnswer pollAnswer = v3;
                PollId pollId = pollAnswer != null ? pollAnswer.getPollId() : null;
                object3 = pollsForBatch;
                object42 = object3.iterator();
                while (object42.hasNext()) {
                    it = object42.next();
                    Poll it2 = (Poll)it;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)pollId)) continue;
                    object2 = it;
                    break block14;
                }
                object2 = null;
            }
            if ((Poll)object2 == null) {
                throw new IllegalStateException("Missing poll for answer: '" + (PollAnswerId)pollAnswerId + "'.");
            }
            if (poll.getPrivacy() == PollPrivacy.ANONYMOUS) {
                set2 = null;
            } else {
                Object v = postsForBatch.get(poll.getPostId());
                if (v == null) {
                    object3 = "Required value was null.";
                    throw new IllegalArgumentException(object3.toString());
                }
                Post post = (Post)v;
                if (poll.getPrivacy() == PollPrivacy.MANAGERS_ONLY && !Intrinsics.areEqual((Object)authContext.getUser(), (Object)post.getAuthorId()) && !authContext.mayManage((ItemId)post.getChannelId())) {
                    set2 = null;
                } else {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = votesForBatch;
                    boolean $i$f$filter = false;
                    object42 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        PollVote it = (PollVote)element$iv$iv3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getAnswerId(), (Object)pollAnswerId)) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                }
            }
            Set set3 = set2;
            object.put(collection, set3);
        }
        return result$iv;
    }
}

