/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migrateditem;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.migrateditem.BrokenCount;
import de.justsoftware.news.domain.migrateditem.MigrationFixService;
import de.justsoftware.news.domain.migrateditem.Quill;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0012J\b\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/domain/migrateditem/MigrationFixService;", "", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "(Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "countBrokenItems", "Lde/justsoftware/news/domain/migrateditem/BrokenCount;", "fixComments", "", "fixDelta", "", "text", "fixPosts", "Companion", "news-service"})
public class MigrationFixService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final Logger log;

    public MigrationFixService(@NotNull PostRepo postRepo, @NotNull PostCommentRepo commentRepo) {
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        this.postRepo = postRepo;
        this.commentRepo = commentRepo;
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public BrokenCount countBrokenItems() {
        void $this$fold$iv;
        Iterable comments;
        void $this$fold$iv2;
        Iterable posts2;
        Iterable iterable = this.postRepo.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"postRepo.findAll()");
        Iterable iterable2 = posts2 = iterable;
        Integer initial$iv = 0;
        boolean $i$f$fold22 = false;
        Integer accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv2) {
            int n;
            Post post = (Post)element$iv;
            int acc = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            try {
                void post2;
                this.mapper.readTree(post2.getJsonContent());
                n = acc;
            }
            catch (JacksonException e) {
                n = acc + 1;
            }
            accumulator$iv = n;
        }
        Number brokenPostCount = accumulator$iv;
        Iterable iterable3 = this.commentRepo.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"commentRepo.findAll()");
        Iterable $i$f$fold22 = comments = iterable3;
        Integer initial$iv2 = 0;
        boolean $i$f$fold = false;
        Integer accumulator$iv2 = initial$iv2;
        for (Object element$iv : $this$fold$iv) {
            int n;
            PostComment bl = (PostComment)element$iv;
            int acc = ((Number)accumulator$iv2).intValue();
            boolean bl2 = false;
            try {
                void comment;
                this.mapper.readTree(comment.getJsonContent());
                n = acc;
            }
            catch (JacksonException e) {
                n = acc + 1;
            }
            accumulator$iv2 = n;
        }
        Number brokenCommentCount = accumulator$iv2;
        return new BrokenCount(brokenPostCount, brokenCommentCount);
    }

    /*
     * WARNING - void declaration
     */
    public void fixPosts() {
        void $this$mapTo$iv$iv;
        void $this$fold$iv;
        Iterable posts2;
        log.info("Finding and fixing Posts with invalid json content");
        Iterable iterable = this.postRepo.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"postRepo.findAll()");
        Iterable iterable2 = posts2 = iterable;
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        Iterable accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            List list;
            void post;
            Post post2 = (Post)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            try {
                this.mapper.readTree(post.getJsonContent());
                list = acc;
            }
            catch (JacksonException e) {
                Collection collection = acc;
                Intrinsics.checkNotNullExpressionValue((Object)post, (String)"post");
                list = CollectionsKt.plus((Collection)collection, (Object)Post.copy$default((Post)post, null, null, null, null, null, null, null, (String)this.fixDelta(post.getText()), null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (int)32639, null));
            }
            accumulator$iv = list;
        }
        List fixedPosts = accumulator$iv;
        this.postRepo.saveAll((Iterable)fixedPosts);
        Iterable $this$map$iv = fixedPosts;
        boolean $i$f$map = false;
        accumulator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post bl = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        List ids = (List)destination$iv$iv;
        log.info("Fixed " + fixedPosts.size() + " Posts with invalid json content. Ids: " + ids);
    }

    /*
     * WARNING - void declaration
     */
    public void fixComments() {
        void $this$mapTo$iv$iv;
        void $this$fold$iv;
        Iterable comments;
        log.info("Finding and fixing Comments with invalid json content");
        Iterable iterable = this.commentRepo.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"commentRepo.findAll()");
        Iterable iterable2 = comments = iterable;
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        Iterable accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            List list;
            void comment;
            PostComment postComment = (PostComment)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            try {
                this.mapper.readTree(comment.getJsonContent());
                list = acc;
            }
            catch (JacksonException e) {
                Collection collection = acc;
                Intrinsics.checkNotNullExpressionValue((Object)comment, (String)"comment");
                list = CollectionsKt.plus((Collection)collection, (Object)PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, (String)this.fixDelta(comment.getText()), null, (boolean)false, null, null, (int)7935, null));
            }
            accumulator$iv = list;
        }
        List fixedComments = accumulator$iv;
        this.commentRepo.saveAll((Iterable)fixedComments);
        Iterable $this$map$iv = fixedComments;
        boolean $i$f$map = false;
        accumulator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostComment bl = (PostComment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        List ids = (List)destination$iv$iv;
        log.info("Fixed " + fixedComments.size() + " Comments with invalid json content. Ids: " + ids);
    }

    private String fixDelta(String text) {
        Quill.Insert insert = new Quill.Insert(text);
        Quill.Delta delta = new Quill.Delta(CollectionsKt.listOf((Object)insert));
        String string = this.mapper.writeValueAsString((Object)delta);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString(delta)");
        return string;
    }

    static {
        Logger logger = LoggerFactory.getLogger(MigrationFixService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(MigrationFixService::class.java)");
        log = logger;
    }
}

