/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migrateditem;

import de.justsoftware.news.ItemId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.migrateditem.MigratedItem;
import de.justsoftware.news.domain.migrateditem.MigratedItemRepo;
import de.justsoftware.news.domain.migrateditem.MigratedItemService;
import de.justsoftware.news.util.Unauthorized;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/domain/migrateditem/MigratedItemService;", "", "migratedItemRepo", "Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;", "(Lde/justsoftware/news/domain/migrateditem/MigratedItemRepo;)V", "findByItemId", "Lde/justsoftware/news/domain/migrateditem/MigratedItem;", "itemId", "Lde/justsoftware/news/ItemId;", "findItemIdByLegacyId", "legacyId", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "insert", "newItem", "Companion", "news-service"})
public class MigratedItemService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigratedItemRepo migratedItemRepo;
    @NotNull
    private static final Logger log;

    public MigratedItemService(@NotNull MigratedItemRepo migratedItemRepo) {
        Intrinsics.checkNotNullParameter((Object)migratedItemRepo, (String)"migratedItemRepo");
        this.migratedItemRepo = migratedItemRepo;
    }

    @Nullable
    public ItemId findItemIdByLegacyId(@NotNull String legacyId, @NotNull AuthorizationContext authContext) {
        MigratedItem migratedItem;
        Intrinsics.checkNotNullParameter((Object)legacyId, (String)"legacyId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        MigratedItem migratedItem2 = migratedItem = this.migratedItemRepo.findByLegacyId(legacyId);
        if (migratedItem2 != null) {
            MigratedItem it = migratedItem2;
            boolean bl = false;
            authContext.checkRead(it.getItemId());
        }
        MigratedItem migratedItem3 = migratedItem;
        return migratedItem3 != null ? migratedItem3.getItemId() : null;
    }

    @Unauthorized
    @Nullable
    public MigratedItem findByItemId(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.migratedItemRepo.findByItemId(itemId);
    }

    @Unauthorized
    @NotNull
    public MigratedItem insert(@NotNull MigratedItem newItem) {
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        MigratedItem migratedItem = this.migratedItemRepo.findByItemId(newItem.getItemId());
        if (migratedItem != null) {
            log.warn(migratedItem.getItemId() + " : " + migratedItem.getLegacyId() + " already migrated");
            return migratedItem;
        }
        this.migratedItemRepo.insert(newItem.getItemId(), newItem.getLegacyId());
        return newItem;
    }

    static {
        Logger logger = LoggerFactory.getLogger(MigratedItemService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(MigratedItemService::class.java)");
        log = logger;
    }
}

