/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migrateditem;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.migrateditem.MigratedItemService;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/news/domain/migrateditem/MigratedItemDataFetcher;", "", "migratedItemService", "Lde/justsoftware/news/domain/migrateditem/MigratedItemService;", "(Lde/justsoftware/news/domain/migrateditem/MigratedItemService;)V", "itemIdForLegacyId", "Lde/justsoftware/news/ItemId;", "legacyId", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "news-service"})
public class MigratedItemDataFetcher {
    @NotNull
    private final MigratedItemService migratedItemService;

    public MigratedItemDataFetcher(@NotNull MigratedItemService migratedItemService) {
        Intrinsics.checkNotNullParameter((Object)migratedItemService, (String)"migratedItemService");
        this.migratedItemService = migratedItemService;
    }

    @DgsQuery(field="itemIdForLegacyId")
    @Nullable
    public ItemId itemIdForLegacyId(@InputArgument @NotNull String legacyId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)legacyId, (String)"legacyId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return this.migratedItemService.findItemIdByLegacyId(legacyId, authContext);
    }
}

