/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.CommentId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.ProfileId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.comment.PostCommentService$findAllByIds$;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.events.PostCommentCreatedEvent;
import de.justsoftware.news.events.PostCommentUpdatedMentionsEvent;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.Sort;
import de.justsoftware.news.util.Unauthorized;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0017J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001b0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020%0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/news/domain/comment/PostCommentService;", "", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "(Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "createComment", "Lde/justsoftware/news/domain/comment/PostComment;", "postId", "Lde/justsoftware/news/PostId;", "text", "", "jsonContent", "parentId", "Lde/justsoftware/news/ItemId;", "referenceId", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "deleteComment", "Lde/justsoftware/news/CommentId;", "commentId", "editComment", "id", "findAllByIds", "", "commentIds", "findAllByPostId", "sort", "Lde/justsoftware/news/util/Sort;", "findById", "findNestedCommentsByParent", "", "parentIds", "getCommentCount", "", "postIds", "", "news-service"})
public class PostCommentService {
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final PostRepo postRepo;

    public PostCommentService(@NotNull ApplicationEventPublisher eventPublisher, @NotNull PostCommentRepo commentRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.eventPublisher = eventPublisher;
        this.commentRepo = commentRepo;
        this.postRepo = postRepo;
    }

    @NotNull
    public PostComment createComment(@NotNull PostId postId, @NotNull String text, @NotNull String jsonContent, @Nullable ItemId parentId, @Nullable ItemId referenceId, @NotNull AuthorizationContext authContext) {
        ItemId itemId;
        ItemId itemId2;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        authContext.checkPostAction(post.getId(), PostAction.COMMENT);
        CommentId commentId = CommentId.Companion.random();
        Instant now = Instant.now();
        PostCommentRepo postCommentRepo = this.commentRepo;
        ItemId itemId3 = parentId;
        if (itemId3 == null) {
            itemId3 = itemId2 = (ItemId)postId;
        }
        if ((itemId = referenceId) == null) {
            itemId = (ItemId)postId;
        }
        ItemId itemId4 = itemId;
        ProfileId profileId = authContext.getUser();
        ProfileId profileId2 = authContext.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        postCommentRepo.insert(commentId, postId, itemId2, itemId4, profileId, now, now, profileId2, jsonContent, text);
        this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentCreatedEvent(postId, parentId, jsonContent, authContext.getUser(), authContext.getTenantId()));
        return this.commentRepo.getById(commentId);
    }

    public static /* synthetic */ PostComment createComment$default(PostCommentService postCommentService, PostId postId, String string, String string2, ItemId itemId, ItemId itemId2, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createComment");
        }
        if ((n & 8) != 0) {
            itemId = (ItemId)postId;
        }
        if ((n & 0x10) != 0) {
            itemId2 = (ItemId)postId;
        }
        return postCommentService.createComment(postId, string, string2, itemId, itemId2, authorizationContext);
    }

    @NotNull
    public PostComment editComment(@NotNull CommentId id, @NotNull String text, @NotNull String jsonContent, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment origin = this.commentRepo.getById(id);
        Post post = this.postRepo.getByIdAndDeletedFalse(origin.getPostId());
        authContext.checkPostCommentAction(post.getChannelId(), origin, PostCommentAction.EDIT);
        Instant instant = Instant.now();
        ProfileId profileId = authContext.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        PostComment update = PostComment.copy$default((PostComment)origin, null, null, null, null, null, null, (Instant)instant, (ProfileId)profileId, (String)jsonContent, (String)text, (boolean)false, null, null, (int)7231, null);
        this.commentRepo.save((Object)update);
        Set originMentions = QuillUtils.Companion.extractMentions(origin.getJsonContent());
        Set updateMentions = QuillUtils.Companion.extractMentions(update.getJsonContent());
        Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
        if (!((Collection)newMentions).isEmpty()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentUpdatedMentionsEvent(update.getPostId(), authContext.getTenantId(), (Collection)newMentions));
        }
        return update;
    }

    @Nullable
    public PostComment findById(@NotNull CommentId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment postComment = (PostComment)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.commentRepo), (Object)id);
        if (postComment == null) {
            return null;
        }
        PostComment comment = postComment;
        authContext.checkRead((ItemId)comment.getPostId());
        return comment;
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByPostId(@NotNull PostId postId, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return this.commentRepo.findAllByParentId((ItemId)postId, sort);
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByIds(@NotNull List<CommentId> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        Iterable iterable = this.commentRepo.findAllById((Iterable)commentIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"commentRepo.findAllById(commentIds)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(commentIds)));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<ItemId, List<PostComment>> findNestedCommentsByParent(@NotNull List<? extends ItemId> parentIds, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        if (parentIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set comments = this.commentRepo.findAllByParentIdIn(parentIds, sort);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ItemId itemId = (ItemId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = comments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void id;
                PostComment it = (PostComment)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getParentId(), (Object)id)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        return result$iv;
    }

    @NotNull
    public CommentId deleteComment(@NotNull CommentId commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.commentRepo.findById((Object)commentId).ifPresent(arg_0 -> PostCommentService.deleteComment$lambda$3((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        return commentId;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PostId, Integer> getCommentCount(@NotNull Set<PostId> postIds) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable $this$map$iv = postIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            PostId postId = (PostId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toTypedString());
        }
        Set stringIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = this.commentRepo.commentCountByPostIds(stringIds);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map counts = destination$iv$iv2;
        Iterable $this$associateWith$iv = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            PostId element$iv$iv2 = (PostId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = ((Number)counts.getOrDefault(it, 0)).intValue();
            object.put(t, n);
        }
        return result$iv;
    }

    private static final void deleteComment$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PostRepo access$getPostRepo$p(PostCommentService $this) {
        return $this.postRepo;
    }

    public static final /* synthetic */ PostCommentRepo access$getCommentRepo$p(PostCommentService $this) {
        return $this.commentRepo;
    }
}

