/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel.permission;

import de.justsoftware.news.ChannelId;
import de.justsoftware.news.PermissionId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionAdd;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionChanges;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionUpdate;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0017J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "deletePermissions", "", "event", "Lde/justsoftware/news/events/GroupDeletedEvent;", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "findAllByChannelId", "", "Lde/justsoftware/news/domain/channel/permission/ChannelPermission;", "channelId", "Lde/justsoftware/news/ChannelId;", "set", "changes", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionChanges;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ChannelPermissionService {
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public ChannelPermissionService(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
    }

    @Unauthorized
    @NotNull
    public List<ChannelPermission> findAllByChannelId(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.channelPermissionRepo.findAllByChannelId(channelId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void set(@NotNull ChannelPermissionChanges changes, @NotNull AuthorizationContext authContext) {
        List list;
        void $this$mapTo$iv$iv;
        ChannelPermission origin;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Object it;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(changes.getChannelId(), ChannelAction.MANAGE_PERMISSIONS);
        Iterable $this$forEach$iv = changes.getAdds();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it = (ChannelPermissionAdd)element$iv2;
            boolean bl = false;
            this.channelPermissionRepo.insert(PermissionId.Companion.random(), changes.getChannelId(), it.getGranteeId(), it.getRole());
        }
        List updatedOriginPermissions = new ArrayList();
        it = changes.getUpdates();
        Object object = this.channelPermissionRepo;
        boolean $i$f$map22 = false;
        void var9_19 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it2;
            ChannelPermissionUpdate channelPermissionUpdate = (ChannelPermissionUpdate)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getPermissionId());
        }
        Iterable iterable = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"channelPermissionRepo.fi\u2026.map { it.permissionId })");
        element$iv2 = iterable;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Object v1;
            block7: {
                Object item$iv$iv2;
                item$iv$iv2 = (ChannelPermission)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)origin.getChannelId(), (Object)changes.getChannelId())) {
                    boolean $i$a$-require-ChannelPermissionService$set$updatedPermissions$2$22 = false;
                    String $i$a$-require-ChannelPermissionService$set$updatedPermissions$2$22 = "Only changes for the same channel are allowed.";
                    throw new IllegalArgumentException($i$a$-require-ChannelPermissionService$set$updatedPermissions$2$22.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)origin, (String)"origin");
                updatedOriginPermissions.add(origin);
                Iterable iterable2 = changes.getUpdates();
                for (Object t : iterable2) {
                    ChannelPermissionUpdate it3 = (ChannelPermissionUpdate)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it3.getPermissionId(), (Object)origin.getId())) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            Intrinsics.checkNotNull(v1);
            PermissionRole updatedRole = ((ChannelPermissionUpdate)v1).getRole();
            object.add(ChannelPermission.copy$default((ChannelPermission)origin, null, null, null, (PermissionRole)updatedRole, (int)7, null));
        }
        List it2 = (List)destination$iv$iv2;
        boolean $i$a$-let-ChannelPermissionService$set$updatedPermissions$42 = false;
        Iterable iterable3 = this.channelPermissionRepo.saveAll((Iterable)it2);
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"channelPermissionRepo.fi\u2026missionRepo.saveAll(it) }");
        Iterable updatedPermissions = iterable3;
        Iterable iterable4 = this.channelPermissionRepo.findAllById((Iterable)changes.getDeletes());
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"channelPermissionRepo.findAllById(changes.deletes)");
        $this$map$iv = iterable4;
        $i$f$map = false;
        Iterable $i$a$-let-ChannelPermissionService$set$updatedPermissions$42 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            origin = (ChannelPermission)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it4.getChannelId(), (Object)changes.getChannelId())) {
                boolean bl3 = false;
                String string = "Only changes for the same channel are allowed.";
                throw new IllegalArgumentException(string.toString());
            }
            object.add(it4);
        }
        List it3 = list = (List)destination$iv$iv2;
        boolean bl = false;
        this.channelPermissionRepo.deleteAll((Iterable)it3);
        List deletedPermissions = list;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @EventListener
    public void deletePermissions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getProfileId());
    }

    @EventListener
    public void deletePermissions(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getUserGroupId());
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(ChannelPermissionService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(ChannelPermissionService $this) {
        return $this.eventPublisher;
    }
}

