/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel.permission;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelDataFetcherKt;
import de.justsoftware.news.domain.channel.ChannelDataLoader;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionDataFetcherKt;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionService;
import de.justsoftware.news.domain.user.UserDataLoader;
import de.justsoftware.news.graphql.generated.types.ChannelPermission;
import de.justsoftware.news.graphql.generated.types.SetChannelPermissionsInput;
import de.justsoftware.news.graphql.generated.types.User;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/news/domain/channel/permission/ChannelPermissionDataFetcher;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "channelPermissionService", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;)V", "channel", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/graphql/generated/types/Channel;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "grantee", "Lde/justsoftware/news/graphql/generated/types/User;", "setChannelPermissions", "input", "Lde/justsoftware/news/graphql/generated/types/SetChannelPermissionsInput;", "news-service"})
public class ChannelPermissionDataFetcher {
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final ChannelPermissionService channelPermissionService;

    public ChannelPermissionDataFetcher(@NotNull ChannelService channelService, @NotNull ChannelPermissionService channelPermissionService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)channelPermissionService, (String)"channelPermissionService");
        this.channelService = channelService;
        this.channelPermissionService = channelPermissionService;
    }

    @DgsMutation(field="setChannelPermissions")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel setChannelPermissions(@InputArgument @NotNull SetChannelPermissionsInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelPermissionService.set(ChannelPermissionDataFetcherKt.access$toDomain((SetChannelPermissionsInput)input), authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(input.getChannelId(), authContext));
    }

    @DgsData(parentType="ChannelPermission", field="channel")
    @NotNull
    public CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Channel>> channel(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ChannelDataLoader.class);
        ChannelId channelId = ((ChannelPermission)dfe.getSource()).getChannelId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(channelId)");
        return completableFuture;
    }

    @DgsData(parentType="ChannelPermission", field="grantee")
    @NotNull
    public CompletableFuture<List<User>> grantee(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(UserDataLoader.class);
        String granteeId = ((ChannelPermission)dfe.getSource()).getGranteeId();
        CompletableFuture completableFuture = dataLoader.load((Object)UserId.Companion.fromString(granteeId));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"dataLoader.load(UserId.fromString(granteeId))");
        return completableFuture;
    }
}

