/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.permission;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.news.ChannelId;
import de.justsoftware.news.ItemId;
import de.justsoftware.news.PostId;
import de.justsoftware.news.UserId;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 52\u00020\u0001:\u00015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0012J\u0016\u0010,\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020$0.H\u0016J\u0016\u0010/\u001a\u00020$2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016J\u0016\u00103\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020$0.H\u0012J\u0016\u00104\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020$0.H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "permissionCleaningProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "singleRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;", "(Lde/justsoftware/permission/client/kafka/PermissionItemProducer;Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentProducer;)V", "addPermission", "Lde/justsoftware/news/kafka/KafkaPublishOperation;", "itemId", "Lde/justsoftware/news/ItemId;", "granteeId", "Lde/justsoftware/news/UserId;", "role", "Lde/justsoftware/news/domain/channel/permission/PermissionRole;", "addPermissions", "addedPermissions", "", "Lde/justsoftware/news/connector/permission/PermissionItem;", "applyChannelPermission", "channelPermission", "Lde/justsoftware/news/domain/channel/permission/ChannelPermission;", "channelId", "Lde/justsoftware/news/ChannelId;", "deleteItem", "deleteItems", "itemIds", "", "deletePermissions", "deletedPermissions", "publishChannel", "parent", "publishNewsConfig", "", "publishPost", "postId", "Lde/justsoftware/news/PostId;", "published", "", "publishPostItem", "Lde/justsoftware/permission/client/kafka/WaitForOffsets;", "republishChannelRoles", "doRepublish", "Lkotlin/Function0;", "republishChannels", "channels", "", "Lde/justsoftware/news/domain/channel/Channel;", "republishPostRoles", "republishPosts", "Companion", "news-service"})
public class PermissionKafkaProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private final KafkaCleaningProducer<String, String> permissionCleaningProducer;
    @NotNull
    private final SingleRoleAssignmentProducer singleRoleAssignmentProducer;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String TOPIC = "just.permission.config";
    @NotNull
    private static final String CONFIG_FILE_PATH = "/news-permission-config.json";

    public PermissionKafkaProducer(@NotNull PermissionItemProducer permissionItemProducer, @NotNull KafkaCleaningProducer<String, String> permissionCleaningProducer, @NotNull SingleRoleAssignmentProducer singleRoleAssignmentProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        Intrinsics.checkNotNullParameter(permissionCleaningProducer, (String)"permissionCleaningProducer");
        Intrinsics.checkNotNullParameter((Object)singleRoleAssignmentProducer, (String)"singleRoleAssignmentProducer");
        this.permissionItemProducer = permissionItemProducer;
        this.permissionCleaningProducer = permissionCleaningProducer;
        this.singleRoleAssignmentProducer = singleRoleAssignmentProducer;
    }

    @NotNull
    public KafkaPublishOperation addPermission(@NotNull ItemId itemId, @NotNull UserId granteeId, @NotNull PermissionRole role) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        return this.addPermissions(CollectionsKt.listOf((Object)new PermissionItem(itemId, granteeId, role)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation addPermissions(@NotNull List<PermissionItem> addedPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addedPermissions, (String)"addedPermissions");
        Iterable $this$map$iv = addedPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionItem permissionItem = (PermissionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.singleRoleAssignmentProducer.addRoleReplacement(Role.itemRole((String)it.getRole().name(), (String)it.getItemId().toTypedString()), Role.create((String)it.getGranteeId().toTypedString())));
        }
        Stream stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"addedPermissions\n       \u2026 )\n            }.stream()");
        Stream waitForOffsetsStream = stream;
        return new KafkaPublishOperation(waitForOffsetsStream);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation deletePermissions(@NotNull List<PermissionItem> deletedPermissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletedPermissions, (String)"deletedPermissions");
        Iterable $this$map$iv = deletedPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionItem permissionItem = (PermissionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.singleRoleAssignmentProducer.deleteRoleReplacement(Role.itemRole((String)it.getRole().name(), (String)it.getItemId().toTypedString()), Role.create((String)it.getGranteeId().toTypedString())));
        }
        Stream stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"deletedPermissions\n     \u2026 )\n            }.stream()");
        Stream waitForOffsetsStream = stream;
        return new KafkaPublishOperation(waitForOffsetsStream);
    }

    @NotNull
    public KafkaPublishOperation publishChannel(@NotNull ChannelId channelId, @NotNull ItemId parent) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(channelId.toTypedString(), Optional.of(parent.toTypedString()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"permissionItemProducer.p\u2026edString())\n            )");
        return new KafkaPublishOperation(waitForOffsets);
    }

    @NotNull
    public KafkaPublishOperation publishPost(@NotNull PostId postId, @NotNull ChannelId channelId, boolean published) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return new KafkaPublishOperation(this.publishPostItem(postId, channelId, published));
    }

    public void republishChannels(@NotNull Iterable<Channel> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        this.permissionItemProducer.republish("CHANNEL", () -> PermissionKafkaProducer.republishChannels$lambda$3(channels, this));
    }

    public void republishPosts(@NotNull Function0<Unit> doRepublish) {
        Intrinsics.checkNotNullParameter(doRepublish, (String)"doRepublish");
        this.permissionItemProducer.republish("POST", () -> PermissionKafkaProducer.republishPosts$lambda$4(this, doRepublish));
    }

    private void republishPostRoles(Function0<Unit> doRepublish) {
        log.debug("Republishing post role replacements");
        Object[] objectArray = new String[]{"READER", "WRITER", "MANAGER"};
        this.singleRoleAssignmentProducer.republishForItemRoles("POST", SetsKt.setOf((Object[])objectArray), () -> PermissionKafkaProducer.republishPostRoles$lambda$5(doRepublish));
    }

    private WaitForOffsets publishPostItem(PostId postId, ChannelId channelId, boolean published) {
        String[] stringArray = new String[]{!published ? "SCHEDULED" : null};
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem(postId.toTypedString(), Optional.of(channelId.toTypedString()), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"permissionItemProducer.p\u2026LED\" else null,\n        )");
        return waitForOffsets;
    }

    @NotNull
    public KafkaPublishOperation deleteItem(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.deleteItems(SetsKt.setOf((Object)itemId));
    }

    @NotNull
    public KafkaPublishOperation deleteItems(@NotNull Set<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Stream<WaitForOffsets> stream = itemIds.stream().map(arg_0 -> PermissionKafkaProducer.deleteItems$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"fun deleteItems(itemIds:\u2026g())\n            })\n    }");
        return new KafkaPublishOperation(stream);
    }

    public void publishNewsConfig() {
        URL config;
        log.info("Sending Permission Config to TOPIC: 'just.permission.config'");
        URL uRL = this.getClass().getResource(CONFIG_FILE_PATH);
        if (uRL == null) {
            throw new RuntimeException("Cant find file '/news-permission-config.json' in resources!");
        }
        uRL = config = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        this.permissionCleaningProducer.send(new ProducerRecord(TOPIC, (Object)"CHANNEL", (Object)new String(byArray, charset)));
    }

    public void republishChannelRoles(@NotNull Function0<Unit> doRepublish) {
        Intrinsics.checkNotNullParameter(doRepublish, (String)"doRepublish");
        log.debug("Republishing channel role replacements");
        Object[] objectArray = new String[]{"READER", "WRITER", "MANAGER"};
        this.singleRoleAssignmentProducer.republishForItemRoles("CHANNEL", SetsKt.setOf((Object[])objectArray), () -> PermissionKafkaProducer.republishChannelRoles$lambda$7(doRepublish));
    }

    @NotNull
    public KafkaPublishOperation applyChannelPermission(@NotNull ChannelPermission channelPermission, @NotNull ChannelId channelId) {
        Role role;
        Intrinsics.checkNotNullParameter((Object)channelPermission, (String)"channelPermission");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        switch (WhenMappings.$EnumSwitchMapping$0[channelPermission.getRole().ordinal()]) {
            case 1: {
                role = Role.reader((String)channelId.toTypedString());
                break;
            }
            case 2: {
                role = Role.writer((String)channelId.toTypedString());
                break;
            }
            case 3: {
                role = Role.manager((String)channelId.toTypedString());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"when (channelPermission.\u2026oTypedString())\n        }");
        Role grantedRole = role;
        Role role2 = Role.create((String)channelPermission.getGranteeId().toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role2, (String)"create(channelPermission\u2026ranteeId.toTypedString())");
        Role granteeRole = role2;
        WaitForOffsets waitForOffsets = this.singleRoleAssignmentProducer.addRoleReplacement(grantedRole, granteeRole);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"singleRoleAssignmentProd\u2026grantedRole, granteeRole)");
        WaitForOffsets waitForOffsets2 = waitForOffsets;
        return new KafkaPublishOperation(waitForOffsets2);
    }

    private static final void republishChannels$lambda$3(Iterable $channels, PermissionKafkaProducer this$0) {
        Intrinsics.checkNotNullParameter((Object)$channels, (String)"$channels");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            this$0.permissionItemProducer.publishItem(channel.getId().toTypedString(), Optional.of(channel.getTenantId().toTypedString()), new String[0]);
        }
    }

    private static final void republishPosts$lambda$4(PermissionKafkaProducer this$0, Function0 $doRepublish) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$doRepublish, (String)"$doRepublish");
        this$0.republishPostRoles((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static final void republishPostRoles$lambda$5(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final WaitForOffsets deleteItems$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WaitForOffsets)$tmp0.invoke(p0);
    }

    private static final void republishChannelRoles$lambda$7(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ PermissionItemProducer access$getPermissionItemProducer$p(PermissionKafkaProducer $this) {
        return $this.permissionItemProducer;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionKafkaProducer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PermissionKafkaProducer::class.java)");
        log = logger;
    }
}

