/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import de.justsoftware.mobile.gateway.util.ErrorsKt;
import de.justsoftware.mobile.gateway.wiki.generated.SubscribeWikiMutation;
import de.justsoftware.mobile.gateway.wiki.generated.UnsubscribeWikiMutation;
import de.justsoftware.mobile.gateway.wiki.generated.WikiArticleQuery;
import de.justsoftware.mobile.gateway.wiki.generated.WikiChapterQuery;
import de.justsoftware.mobile.gateway.wiki.generated.WikiQuery;
import de.justsoftware.mobile.gateway.wiki.generated.WikiTeasersQuery;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.SubscriptionFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiArticleFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiChapterFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiFragment;
import de.justsoftware.mobile.gateway.wiki.generated.fragment.WikiTeaserFragment;
import de.justsoftware.mobile.gateway.wiki.service.WikiApiGatewayService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0092\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService;", "", "wikiApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "execute", "T", "Lcom/apollographql/apollo3/api/Operation$Data;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "(Lcom/apollographql/apollo3/api/Operation;)Lcom/apollographql/apollo3/api/Operation$Data;", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/generated/fragment/WikiFragment;", "wikiId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/generated/fragment/WikiArticleFragment;", "articleId", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/generated/fragment/WikiChapterFragment;", "chapterId", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/generated/fragment/WikiTeaserFragment;", "page", "", "size", "onlySubscribed", "", "subscribe", "Lde/justsoftware/mobile/gateway/wiki/generated/fragment/SubscriptionFragment;", "unsubscribe", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nWikiApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiApiGatewayService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n63#1,2:82\n66#1,10:86\n63#1,2:100\n66#1,10:104\n63#1,2:114\n66#1,10:118\n63#1,2:128\n66#1,10:132\n63#1,2:142\n66#1,10:146\n63#1,2:156\n66#1,10:160\n36#2:84\n48#2:85\n36#2:102\n48#2:103\n36#2:116\n48#2:117\n36#2:130\n48#2:131\n36#2:144\n48#2:145\n36#2:158\n48#2:159\n36#2:170\n48#2:171\n1549#3:96\n1620#3,3:97\n*S KotlinDebug\n*F\n+ 1 WikiApiGatewayService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiApiGatewayService\n*L\n34#1:82,2\n34#1:86,10\n39#1:100,2\n39#1:104,10\n44#1:114,2\n44#1:118,10\n49#1:128,2\n49#1:132,10\n54#1:142,2\n54#1:146,10\n59#1:156,2\n59#1:160,10\n34#1:84\n34#1:85\n39#1:102\n39#1:103\n44#1:116\n44#1:117\n49#1:130\n49#1:131\n54#1:144\n54#1:145\n59#1:158\n59#1:159\n63#1:170\n63#1:171\n34#1:96\n34#1:97,3\n*E\n"})
public class WikiApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String wikiApiUrl;
    @NotNull
    private final WebClient webClient;
    private static final Logger LOG = LoggerFactory.getLogger(WikiApiGatewayService.class);

    public WikiApiGatewayService(@Value(value="${just.wiki.graphql.url}") @NotNull String wikiApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)wikiApiUrl, (String)"wikiApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.wikiApiUrl = wikiApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiTeaserFragment> getWikiTeasers(int page, int size, boolean onlySubscribed) {
        void $this$mapTo$iv$iv;
        void uri$iv$iv;
        Iterable $this$executeGraphqlOperation$iv$iv;
        WikiTeasersQuery query = new WikiTeasersQuery(page, size, onlySubscribed);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)query).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Iterable $this$map$iv = ((WikiTeasersQuery.Data)data).getWikiTeasers();
        boolean $i$f$map = false;
        $this$executeGraphqlOperation$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            WikiTeasersQuery.WikiTeaser wikiTeaser = (WikiTeasersQuery.WikiTeaser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(p0.getWikiTeaserFragment());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public WikiFragment getWiki(@NotNull String wikiId) {
        void uri$iv$iv;
        void $this$executeGraphqlOperation$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        WikiQuery query = new WikiQuery(wikiId);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)query).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        WikiQuery.Wiki wiki = ((WikiQuery.Data)data).getWiki();
        return wiki != null ? wiki.getWikiFragment() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SubscriptionFragment subscribe(@NotNull String wikiId) {
        void uri$iv$iv;
        void $this$executeGraphqlOperation$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        SubscribeWikiMutation mutation = new SubscribeWikiMutation(wikiId);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)mutation).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        SubscribeWikiMutation.Subscription subscription = ((SubscribeWikiMutation.Data)data).getSubscription();
        return subscription != null ? subscription.getSubscriptionFragment() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SubscriptionFragment unsubscribe(@NotNull String wikiId) {
        void uri$iv$iv;
        void $this$executeGraphqlOperation$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        UnsubscribeWikiMutation mutation = new UnsubscribeWikiMutation(wikiId);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)mutation).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        UnsubscribeWikiMutation.Subscription subscription = ((UnsubscribeWikiMutation.Data)data).getSubscription();
        return subscription != null ? subscription.getSubscriptionFragment() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public WikiChapterFragment getWikiChapter(@NotNull String chapterId) {
        void uri$iv$iv;
        void $this$executeGraphqlOperation$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        WikiChapterQuery query = new WikiChapterQuery(chapterId);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)query).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        WikiChapterQuery.Chapter chapter = ((WikiChapterQuery.Data)data).getChapter();
        return chapter != null ? chapter.getWikiChapterFragment() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public WikiArticleFragment getWikiArticle(@NotNull String articleId) {
        void uri$iv$iv;
        void $this$executeGraphqlOperation$iv$iv;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        WikiArticleQuery query = new WikiArticleQuery(articleId);
        WikiApiGatewayService this_$iv = this;
        boolean $i$f$execute = false;
        WebClient webClient = this_$iv.webClient;
        URI uRI = new URI(this_$iv.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        ApolloResponse response$iv = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response$iv.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response$iv, (Logger)logger, (String)((Operation)query).name());
        }
        Operation.Data data = response$iv.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        WikiArticleQuery.Article article = ((WikiArticleQuery.Data)data).getArticle();
        return article != null ? article.getWikiArticleFragment() : null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ <T extends Operation.Data> T execute(Operation<T> operation) {
        void uri$iv;
        void $this$executeGraphqlOperation$iv;
        boolean $i$f$execute = false;
        WebClient webClient = this.webClient;
        URI uRI = new URI(this.wikiApiUrl);
        boolean $i$f$executeGraphqlOperation = false;
        Intrinsics.needClassReification();
        ApolloResponse response = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean bl = false;
        if (response.hasErrors()) {
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            ErrorsKt.handleErrors((ApolloResponse)response, (Logger)logger, (String)operation.name());
        }
        Operation.Data data = response.data;
        if (data == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return (T)data;
    }
}

