/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.model.local.UserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.ProfileApiProfile;
import de.justsoftware.mobile.gateway.people.service.MobileApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.ProfileApiGatewayService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "", "mobileApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/MobileApiGatewayService;", "peopleApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "profileApiGatewayService", "Lde/justsoftware/mobile/gateway/people/service/ProfileApiGatewayService;", "(Lde/justsoftware/mobile/gateway/people/service/MobileApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;Lde/justsoftware/mobile/gateway/people/service/ProfileApiGatewayService;)V", "deleteUserImage", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "", "getAttributes", "", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "getProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "tenantId", "query", "offset", "", "limit", "getUserGroupDetails", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroupDetails;", "groupId", "getUserGroupMembers", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n1549#2:87\n1620#2,3:88\n1549#2:91\n1620#2,3:92\n*S KotlinDebug\n*F\n+ 1 PeopleService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleService\n*L\n33#1:83\n33#1:84,3\n46#1:87\n46#1:88,3\n62#1:91\n62#1:92,3\n*E\n"})
public class PeopleService {
    @NotNull
    private final MobileApiGatewayService mobileApiGatewayService;
    @NotNull
    private final PeopleApiGatewayService peopleApiGatewayService;
    @NotNull
    private final ProfileApiGatewayService profileApiGatewayService;

    public PeopleService(@NotNull MobileApiGatewayService mobileApiGatewayService, @NotNull PeopleApiGatewayService peopleApiGatewayService, @NotNull ProfileApiGatewayService profileApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)mobileApiGatewayService, (String)"mobileApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)peopleApiGatewayService, (String)"peopleApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)profileApiGatewayService, (String)"profileApiGatewayService");
        this.mobileApiGatewayService = mobileApiGatewayService;
        this.peopleApiGatewayService = peopleApiGatewayService;
        this.profileApiGatewayService = profileApiGatewayService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Profile> getProfiles(@NotNull String tenantId, @Nullable String query, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = this.peopleApiGatewayService.getProfiles(tenantId, query, offset, limit);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiProfile;
            PeopleApiProfile peopleApiProfile = (PeopleApiProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PeopleApiProfile.Companion.toProfile((PeopleApiProfile)apiProfile));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UserGroup> getUserGroups(@NotNull String tenantId, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = this.peopleApiGatewayService.getUserGroups(tenantId, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiUserGroup;
            PeopleApiUserGroup peopleApiUserGroup = (PeopleApiUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PeopleApiUserGroup.Companion.toUserGroup((PeopleApiUserGroup)apiUserGroup));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public UserGroupDetails getUserGroupDetails(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return PeopleApiUserGroupDetails.Companion.toUserGroupDetails(this.peopleApiGatewayService.getUserGroupDetails(groupId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Profile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable iterable = this.peopleApiGatewayService.getUserGroupMembers(groupId, offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apiProfile;
            PeopleApiProfile peopleApiProfile = (PeopleApiProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PeopleApiProfile.Companion.toProfile((PeopleApiProfile)apiProfile));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ProfileDetails updateUserImage(@NotNull String userId, @NotNull MultipartFile image) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.mobileApiGatewayService.updateUserImage(userId, image);
    }

    @NotNull
    public ProfileDetails deleteUserImage(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.mobileApiGatewayService.deleteUserImage(userId);
    }

    @NotNull
    public List<ProfileSection> getAttributes(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return ProfileApiProfile.Companion.toProfileSections(this.profileApiGatewayService.getProfile(userId));
    }
}

