/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfileSearchResults;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfiles;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroups;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getUserGroupDetails$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0003H\u0012J \u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "", "peopleApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiProfile;", "tenantId", "query", "offset", "", "limit", "getUserGroupDetails", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroupDetails;", "groupId", "getUserGroupMembers", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroup;", "profilesUri", "Ljava/net/URI;", "userGroupDetailsUri", "userGroupMembersUri", "userGroupsUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 4 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n*L\n1#1,112:1\n27#2:113\n27#2:114\n27#2:115\n27#2:116\n11#3:117\n11#3:118\n7#3,5:119\n11#3:125\n9#4:124\n*S KotlinDebug\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n*L\n33#1:113\n49#1:114\n60#1:115\n68#1:116\n82#1:117\n95#1:118\n101#1:119,5\n107#1:125\n101#1:124\n*E\n"})
public class PeopleApiGatewayService {
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final WebClient webClient;

    public PeopleApiGatewayService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.peopleApiUrl = peopleApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getProfiles(@NotNull String tenantId, @Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WebClient webClient = this.webClient;
        URI uRI = this.profilesUri(tenantId, query, offset, limit);
        boolean $i$f$get = false;
        return PeopleApiProfileSearchResults.Companion.toApiProfiles((PeopleApiProfileSearchResults)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfiles$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiUserGroup> getUserGroups(@NotNull String tenantId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupsUri(tenantId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroups)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiUserGroupDetails getUserGroupDetails(@NotNull String groupId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.userGroupDetailsUri(groupId);
        boolean $i$f$get = false;
        return (PeopleApiUserGroupDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUserGroupDetails$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupMembersUri(groupId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    private URI profilesUri(String tenantId, String query, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/profiles";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$profilesUri_u24lambda_u240 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{tenantId};
        $this$profilesUri_u24lambda_u240.queryParam("tenantId", objectArray);
        objectArray = new Object[]{offset};
        $this$profilesUri_u24lambda_u240.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$profilesUri_u24lambda_u240.queryParam("limit", objectArray);
        if (query != null) {
            objectArray = new Object[]{query};
            $this$profilesUri_u24lambda_u240.queryParam("query", objectArray);
        }
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI userGroupsUri(String tenantId, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$userGroupsUri_u24lambda_u241 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{tenantId};
        $this$userGroupsUri_u24lambda_u241.queryParam("tenantId", objectArray);
        objectArray = new Object[]{offset};
        $this$userGroupsUri_u24lambda_u241.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$userGroupsUri_u24lambda_u241.queryParam("limit", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI userGroupDetailsUri(String groupId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups/" + groupId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI userGroupMembersUri(String groupId, int offset, int limit) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.peopleApiUrl + "/usergroups/" + groupId + "/members";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$userGroupMembersUri_u24lambda_u242 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{offset};
        $this$userGroupMembersUri_u24lambda_u242.queryParam("offset", objectArray);
        objectArray = new Object[]{limit};
        $this$userGroupMembersUri_u24lambda_u242.queryParam("limit", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }
}

