/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.service.MobileApiGatewayService;
import de.justsoftware.mobile.gateway.people.service.MobileApiGatewayService$deleteUserImage$;
import de.justsoftware.mobile.gateway.people.service.MobileApiGatewayService$updateUserImage$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0012J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/mobile/gateway/people/service/MobileApiGatewayService;", "", "mobileApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "deleteUserImage", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "deleteUserImageUri", "Ljava/net/URI;", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "updateUserImageUri", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nMobileApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/MobileApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 4 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n*L\n1#1,37:1\n54#2:38\n65#2:39\n72#2:40\n7#3,5:41\n7#3,5:47\n9#4:46\n9#4:52\n*S KotlinDebug\n*F\n+ 1 MobileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/MobileApiGatewayService\n*L\n23#1:38\n23#1:39\n27#1:40\n29#1:41,5\n31#1:47,5\n29#1:46\n31#1:52\n*E\n"})
public class MobileApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mobileApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final String MOBILE_API_IMAGE_PARAMETER_NAME = "image";

    public MobileApiGatewayService(@Value(value="${just.mobile.api.url}") @NotNull String mobileApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)mobileApiUrl, (String)"mobileApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.mobileApiUrl = mobileApiUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProfileDetails updateUserImage(@NotNull String userId, @NotNull MultipartFile image) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)MOBILE_API_IMAGE_PARAMETER_NAME);
        WebClient webClient = this.webClient;
        URI uRI = this.updateUserImageUri(userId);
        String name$iv = MOBILE_API_IMAGE_PARAMETER_NAME;
        boolean $i$f$post = false;
        return (ProfileDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new updateUserImage$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, name$iv, image, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProfileDetails deleteUserImage(@NotNull String userId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteUserImageUri(userId);
        boolean $i$f$delete = false;
        return (ProfileDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new deleteUserImage$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    private URI updateUserImageUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.mobileApiUrl + "/people/" + userId + "/image";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI deleteUserImageUri(String userId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.mobileApiUrl + "/people/" + userId + "/image";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }
}

