/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$archiveNotification$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$openNotifications$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0012J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0012J(\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0012J\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "", "notificationApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "archiveAllNotificationsUri", "Ljava/net/URI;", "notificationsCountUri", "openNotificationsUri", "archiveAllNotifications", "", "archiveNotification", "", "notificationId", "archiveNotificationUri", "getNotifications", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "limit", "", "date", "locale", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "markNotification", "action", "markNotificationUri", "notificationsUri", "openNotifications", "notificationIds", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNotificationApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n+ 2 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n+ 4 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,80:1\n7#2,5:81\n7#2,5:87\n7#2,5:93\n11#2:105\n7#2,5:106\n7#2,5:112\n9#3:86\n9#3:92\n9#3:98\n9#3:111\n9#3:117\n27#4:99\n27#4:100\n67#4:101\n67#4:102\n70#4:103\n67#4:104\n*S KotlinDebug\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n*L\n18#1:81,5\n19#1:87,5\n20#1:93,5\n65#1:105\n73#1:106,5\n78#1:112,5\n18#1:86\n19#1:92\n20#1:98\n73#1:111\n78#1:117\n28#1:99\n37#1:100\n39#1:101\n41#1:102\n44#1:103\n53#1:104\n*E\n"})
public class NotificationApiGatewayService {
    @NotNull
    private final String notificationApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI archiveAllNotificationsUri;
    @NotNull
    private final URI notificationsCountUri;
    @NotNull
    private final URI openNotificationsUri;

    public NotificationApiGatewayService(@Value(value="${just.notification.api.url}") @NotNull String notificationApiUrl, @NotNull WebClient webClient) {
        UriComponentsBuilder uriComponentsBuilder;
        Intrinsics.checkNotNullParameter((Object)notificationApiUrl, (String)"notificationApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.notificationApiUrl = notificationApiUrl;
        this.webClient = webClient;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        NotificationApiGatewayService notificationApiGatewayService = this;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        notificationApiGatewayService.archiveAllNotificationsUri = uRI;
        baseUrl$iv = this.notificationApiUrl + "/notification/count";
        $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder4 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder4, (String)"fromHttpUrl(baseUrl)");
        $this$null = uriComponentsBuilder = uriComponentsBuilder4;
        notificationApiGatewayService = this;
        bl = false;
        URI uRI2 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        notificationApiGatewayService.notificationsCountUri = uRI2;
        baseUrl$iv = this.notificationApiUrl + "/notification/open";
        $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder5 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder5, (String)"fromHttpUrl(baseUrl)");
        $this$null = uriComponentsBuilder = uriComponentsBuilder5;
        notificationApiGatewayService = this;
        bl = false;
        URI uRI3 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        notificationApiGatewayService.openNotificationsUri = uRI3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Notification> getNotifications(@NotNull String state, int limit, @NotNull String date, @NotNull String locale) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        WebClient webClient = this.webClient;
        URI uRI = this.notificationsUri(state, limit, date, locale);
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotifications$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NotificationsCount getNotificationsCount() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.notificationsCountUri;
        boolean $i$f$get = false;
        return (NotificationsCount)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> archiveAllNotifications() {
        void $this$put$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveAllNotificationsUri;
        boolean $i$f$put = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void archiveNotification(@NotNull String notificationId) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveNotificationUri(notificationId);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new archiveNotification$$inlined$put$1((WebClient)$this$put$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void openNotifications(@NotNull List<String> notificationIds) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        WebClient webClient = this.webClient;
        URI uri$iv = this.openNotificationsUri;
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new openNotifications$$inlined$put$1((WebClient)$this$put$iv, uri$iv, notificationIds, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        WebClient webClient = this.webClient;
        URI uRI = this.markNotificationUri(notificationId, action);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI notificationsUri(String state, int limit, String date, String locale) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder $this$notificationsUri_u24lambda_u240 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        Object[] objectArray = new Object[]{state};
        $this$notificationsUri_u24lambda_u240.queryParam("status", objectArray);
        objectArray = new Object[]{limit};
        $this$notificationsUri_u24lambda_u240.queryParam("maxElements", objectArray);
        objectArray = new Object[]{date};
        $this$notificationsUri_u24lambda_u240.queryParam("date", objectArray);
        objectArray = new Object[]{locale};
        $this$notificationsUri_u24lambda_u240.queryParam("locale", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI archiveNotificationUri(String notificationId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive/" + notificationId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }

    private URI markNotificationUri(String notificationId, String action) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/" + notificationId + "/" + action;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder2, (String)"fromHttpUrl(baseUrl)");
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder = uriComponentsBuilder2;
        boolean bl = false;
        UriComponentsBuilder $this$null = uriComponentsBuilder3;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).app\u2026de(UTF_8).build().toUri()");
        return uRI;
    }
}

