/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.service;

import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.news.model.AddPostData;
import de.justsoftware.mobile.gateway.news.model.Channel;
import de.justsoftware.mobile.gateway.news.model.Comment;
import de.justsoftware.mobile.gateway.news.model.CommentContent;
import de.justsoftware.mobile.gateway.news.model.Poll;
import de.justsoftware.mobile.gateway.news.model.Post;
import de.justsoftware.mobile.gateway.news.model.UpdatePostData;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import de.justsoftware.mobile.gateway.news.service.NewsService;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\bH\u0016J>\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\bH\u0016J.\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J \u0010&\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J \u0010)\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\u0016H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010-\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010.\u001a\u00020\u001fH\u0016J \u0010/\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\bH\u0016J\"\u00102\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J \u00103\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u0010\r\u001a\u00020\bH\u0016J\u001e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/justsoftware/mobile/gateway/news/service/NewsService;", "", "gatewayService", "Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "(Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;)V", "addComment", "Lde/justsoftware/mobile/gateway/news/model/Comment;", "postId", "", "parentId", "referenceId", "content", "Lde/justsoftware/mobile/gateway/news/model/CommentContent;", "currentUserId", "addPost", "Lde/justsoftware/mobile/gateway/news/model/Post;", "channelId", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/AddPostData;", "deleteComment", "commentId", "deletePost", "", "getChannel", "Lde/justsoftware/mobile/gateway/news/model/Channel;", "getChannelPosts", "", "offset", "", "limit", "scheduled", "", "pinned", "getChannelSubscribers", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "getChannelSubscribersCount", "getChannels", "getComment", "getFeed", "getPost", "likeComment", "likePost", "markFeedAsRead", "markPostAsRead", "subscribe", "notificationsEnabled", "unlikeComment", "unlikePost", "unsubscribe", "updateComment", "updatePost", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/UpdatePostData;", "voteForPoll", "Lde/justsoftware/mobile/gateway/news/model/Poll;", "pollId", "answerIds", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNewsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,202:1\n179#2,2:203\n*S KotlinDebug\n*F\n+ 1 NewsService.kt\nde/justsoftware/mobile/gateway/news/service/NewsService\n*L\n98#1:203,2\n*E\n"})
public class NewsService {
    @NotNull
    private final NewsApiGatewayService gatewayService;

    public NewsService(@NotNull NewsApiGatewayService gatewayService) {
        Intrinsics.checkNotNullParameter((Object)gatewayService, (String)"gatewayService");
        this.gatewayService = gatewayService;
    }

    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Post.Companion.toPosts(this.gatewayService.getFeed(offset, limit, pinned), currentUserId);
    }

    public void markFeedAsRead() {
        this.gatewayService.markFeedAsRead();
    }

    @NotNull
    public List<Channel> getChannels() {
        return Channel.Companion.toChannels(this.gatewayService.getChannels());
    }

    @NotNull
    public Channel subscribe(@NotNull String channelId, boolean notificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.subscribe(channelId, notificationsEnabled));
    }

    public static /* synthetic */ Channel subscribe$default(NewsService newsService, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: subscribe");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return newsService.subscribe(string, bl);
    }

    @NotNull
    public Channel unsubscribe(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.unsubscribe(channelId));
    }

    @NotNull
    public Channel getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return Channel.Companion.toChannel(this.gatewayService.getChannel(channelId));
    }

    @NotNull
    public List<Post> getChannelPosts(@NotNull String channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Post.Companion.toPosts(this.gatewayService.getPosts(channelId, offset, limit, scheduled, pinned), currentUserId);
    }

    @NotNull
    public Post addPost(@NotNull String channelId, @NotNull AddPostData addPostData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Post.Companion.toPost(this.gatewayService.addPost(channelId, addPostData), currentUserId);
    }

    @NotNull
    public Post getPost(@NotNull String postId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Post.Companion.toPost(this.gatewayService.getPost(postId), currentUserId);
    }

    @NotNull
    public Post updatePost(@NotNull String postId, @NotNull UpdatePostData updatePostData, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Post.Companion.toPost(this.gatewayService.updatePost(postId, updatePostData), currentUserId);
    }

    public void deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.deletePost(postId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Comment getComment(@NotNull String postId, @NotNull String commentId, @NotNull String currentUserId) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
            Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
            Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.getPost(postId, currentUserId).getComments()), (Function1)((Function1)getComment.1.INSTANCE));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Comment it = (Comment)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)commentId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Comment comment = v0;
        if (comment == null) {
            throw new NotFoundException("Comment with id " + commentId + " does not exist for post " + postId + ".");
        }
        return comment;
    }

    @NotNull
    public Comment addComment(@NotNull String postId, @Nullable String parentId, @Nullable String referenceId, @NotNull CommentContent content, @NotNull String currentUserId) {
        Comment comment;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        Comment comment2 = comment = Comment.Companion.toComment(this.gatewayService.addComment(postId, parentId, referenceId, content), currentUserId);
        if (comment2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return comment2;
    }

    public static /* synthetic */ Comment addComment$default(NewsService newsService, String string, String string2, String string3, CommentContent commentContent, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addComment");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return newsService.addComment(string, string2, string3, commentContent, string4);
    }

    @Nullable
    public Comment updateComment(@NotNull String commentId, @NotNull CommentContent content, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        return Comment.Companion.toComment(this.gatewayService.updateComment(commentId, content), currentUserId);
    }

    @NotNull
    public Post deleteComment(@NotNull String postId, @NotNull String commentId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.gatewayService.deleteComment(commentId);
        return this.getPost(postId, currentUserId);
    }

    @NotNull
    public Post likePost(@NotNull String postId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.gatewayService.like(postId);
        return this.getPost(postId, currentUserId);
    }

    @NotNull
    public Post unlikePost(@NotNull String postId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.gatewayService.unlike(postId);
        return this.getPost(postId, currentUserId);
    }

    @NotNull
    public Comment likeComment(@NotNull String postId, @NotNull String commentId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.gatewayService.like(commentId);
        return this.getComment(postId, commentId, currentUserId);
    }

    @NotNull
    public Comment unlikeComment(@NotNull String postId, @NotNull String commentId, @NotNull String currentUserId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        this.gatewayService.unlike(commentId);
        return this.getComment(postId, commentId, currentUserId);
    }

    public void markPostAsRead(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.gatewayService.markPostAsRead(postId);
    }

    @NotNull
    public Poll voteForPoll(@NotNull String pollId, @NotNull List<String> answerIds) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(answerIds, (String)"answerIds");
        return Poll.Companion.toPoll(this.gatewayService.voteForPoll(pollId, answerIds), true);
    }

    @NotNull
    public List<Profile> getChannelSubscribers(@NotNull String channelId, int offset, int limit, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List list = this.gatewayService.getChannelSubscribers(channelId, offset, limit, query);
        List list2 = list != null ? Profile.Companion.toProfiles(list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public int getChannelSubscribersCount(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Integer n = this.gatewayService.getChannelSubscribersCount(channelId);
        return n != null ? n : 0;
    }
}

